/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DHPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute value_;
    protected LongAttribute valueBits_;

    public DHPrivateKey() {
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected DHPrivateKey(Session session, long l2) throws TokenException {
        super(session, l2);
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueBits_ = new LongAttribute(Attribute.VALUE_BITS);
        DHPrivateKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DHPrivateKey dHPrivateKey = (DHPrivateKey)super.clone();
        dHPrivateKey.prime_ = (ByteArrayAttribute)this.prime_.clone();
        dHPrivateKey.base_ = (ByteArrayAttribute)this.base_.clone();
        dHPrivateKey.value_ = (ByteArrayAttribute)this.value_.clone();
        dHPrivateKey.valueBits_ = (LongAttribute)this.valueBits_.clone();
        DHPrivateKey.putAttributesInTable(dHPrivateKey);
        return dHPrivateKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DHPrivateKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)object;
            bl = this == dHPrivateKey || super.equals(dHPrivateKey) && this.prime_.equals(dHPrivateKey.prime_) && this.base_.equals(dHPrivateKey.base_) && this.value_.equals(dHPrivateKey.value_) && this.valueBits_.equals(dHPrivateKey.valueBits_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        return new DHPrivateKey(session, l2);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueBits() {
        return this.valueBits_;
    }

    protected static void putAttributesInTable(DHPrivateKey dHPrivateKey) {
        if (dHPrivateKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dHPrivateKey.attributeTable_.put(Attribute.PRIME, dHPrivateKey.prime_);
        dHPrivateKey.attributeTable_.put(Attribute.BASE, dHPrivateKey.base_);
        dHPrivateKey.attributeTable_.put(Attribute.VALUE, dHPrivateKey.value_);
        dHPrivateKey.attributeTable_.put(Attribute.VALUE_BITS, dHPrivateKey.valueBits_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.prime_);
        Object.getAttributeValue(session, this.objectHandle_, this.base_);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueBits_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Bits (dec): ");
        stringBuffer.append(this.valueBits_.toString(10));
        return stringBuffer.toString();
    }
}

