/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;
import java.io.UnsupportedEncodingException;

public class Clock
extends HardwareFeature {
    protected ByteArrayAttribute value_;

    public Clock() {
        this.hardwareFeatureType_.setLongValue(HardwareFeature.FeatureType.CLOCK);
    }

    protected Clock(Session session, long l2) throws TokenException {
        super(session, l2);
        this.hardwareFeatureType_.setLongValue(HardwareFeature.FeatureType.CLOCK);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        Clock.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        Clock clock = (Clock)super.clone();
        clock.value_ = (ByteArrayAttribute)this.value_.clone();
        Clock.putAttributesInTable(clock);
        return clock;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof Clock) {
            Clock clock = (Clock)object;
            bl = this == clock || super.equals(clock) && this.value_.equals(clock.value_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        return new Clock(session, l2);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public int hashCode() {
        return this.value_.hashCode();
    }

    protected static void putAttributesInTable(Clock clock) {
        if (clock == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        clock.attributeTable_.put(Attribute.VALUE, clock.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value: ");
        try {
            stringBuffer.append(new String(this.value_.getByteArrayValue(), "ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            stringBuffer.append(new String(this.value_.getByteArrayValue()));
        }
        return stringBuffer.toString();
    }
}

