/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.CertificateTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class Certificate
extends Storage {
    protected static VendorDefinedCertificateBuilder vendorCertificateBuilder_;
    protected CertificateTypeAttribute certificateType_;
    protected BooleanAttribute trusted_;

    public Certificate() {
        this.objectClass_.setLongValue(Object.ObjectClass.CERTIFICATE);
    }

    protected Certificate(Session session, long l2) throws TokenException {
        super(session, l2);
        this.objectClass_.setLongValue(Object.ObjectClass.CERTIFICATE);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.certificateType_ = new CertificateTypeAttribute();
        this.trusted_ = new BooleanAttribute(Attribute.TRUSTED);
        Certificate.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        Certificate certificate = (Certificate)super.clone();
        certificate.certificateType_ = (CertificateTypeAttribute)this.certificateType_.clone();
        certificate.trusted_ = (BooleanAttribute)this.trusted_.clone();
        Certificate.putAttributesInTable(certificate);
        return certificate;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof Certificate) {
            Certificate certificate = (Certificate)object;
            bl = this == certificate || super.equals(certificate) && this.certificateType_.equals(certificate.certificateType_);
        }
        return bl;
    }

    public LongAttribute getCertificateType() {
        return this.certificateType_;
    }

    public static String getCertificateTypeName(Long l2) {
        if (l2 == null) {
            throw new NullPointerException("Argument \"certificateType\" must not be null.");
        }
        String string = l2.equals(CertificateType.X_509_PUBLIC_KEY) ? "X.509 Public Key" : (l2.equals(CertificateType.X_509_ATTRIBUTE) ? "X.509 Attribute" : ((l2 & CertificateType.VENDOR_DEFINED) != 0L ? "Vendor Defined" : "<unknown>"));
        return string;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        PKCS11 pKCS11 = session.getModule().getPKCS11Module();
        CertificateTypeAttribute certificateTypeAttribute = new CertificateTypeAttribute();
        Object.getAttributeValue(session, l2, certificateTypeAttribute);
        Long l3 = certificateTypeAttribute.getLongValue();
        Object object = certificateTypeAttribute.isPresent() && l3 != null ? (l3.equals(CertificateType.X_509_PUBLIC_KEY) ? X509PublicKeyCertificate.getInstance(session, l2) : (l3.equals(CertificateType.X_509_ATTRIBUTE) ? X509AttributeCertificate.getInstance(session, l2) : ((l3 & CertificateType.VENDOR_DEFINED) != 0L ? Certificate.getUnknownCertificate(session, l2) : Certificate.getUnknownCertificate(session, l2)))) : Certificate.getUnknownCertificate(session, l2);
        return object;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted_;
    }

    protected static Object getUnknownCertificate(Session session, long l2) throws TokenException {
        Object object;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (vendorCertificateBuilder_ != null) {
            try {
                object = vendorCertificateBuilder_.build(session, l2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = new Certificate(session, l2);
            }
        } else {
            object = new Certificate(session, l2);
        }
        return object;
    }

    public static VendorDefinedCertificateBuilder getVendorDefinedCertificateBuilder() {
        return vendorCertificateBuilder_;
    }

    public int hashCode() {
        return this.certificateType_.hashCode();
    }

    protected static void putAttributesInTable(Certificate certificate) {
        if (certificate == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        certificate.attributeTable_.put(Attribute.CERTIFICATE_TYPE, certificate.certificateType_);
        certificate.attributeTable_.put(Attribute.TRUSTED, certificate.trusted_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.trusted_);
    }

    public static void setVendorDefinedCertificateBuilder(VendorDefinedCertificateBuilder vendorDefinedCertificateBuilder) {
        vendorCertificateBuilder_ = vendorDefinedCertificateBuilder;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Certificate Type: ");
        if (this.certificateType_ != null) {
            stringBuffer.append(this.certificateType_.toString());
        } else {
            stringBuffer.append("<unavailable>");
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Trusted: ");
        stringBuffer.append(this.trusted_.toString());
        return stringBuffer.toString();
    }

    public static interface CertificateType {
        public static final Long X_509_PUBLIC_KEY = new Long(0L);
        public static final Long X_509_ATTRIBUTE = new Long(1L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }

    public static interface VendorDefinedCertificateBuilder {
        public Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

