/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.wrapper.CK_VERSION;

public class Version
implements Cloneable {
    protected byte major_;
    protected byte minor_;

    protected Version() {
    }

    protected Version(CK_VERSION cK_VERSION) {
        if (cK_VERSION == null) {
            throw new NullPointerException("Argument \"ckVersion\" must not be null.");
        }
        this.major_ = cK_VERSION.major;
        this.minor_ = cK_VERSION.minor;
    }

    public Object clone() {
        Version version;
        try {
            version = (Version)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return version;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Version) {
            Version version = (Version)object;
            bl = this == version || this.major_ == version.major_ && this.minor_ == version.minor_;
        }
        return bl;
    }

    public byte getMajor() {
        return this.major_;
    }

    public byte getMinor() {
        return this.minor_;
    }

    public int hashCode() {
        return this.major_ ^ this.minor_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.major_);
        stringBuffer.append('.');
        if (this.minor_ < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.minor_);
        return stringBuffer.toString();
    }
}

