/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Version;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class SlotInfo {
    protected String slotDescription_;
    protected String manufacturerID_;
    protected Version hardwareVersion_;
    protected Version firmwareVersion_;
    protected boolean tokenPresent_;
    protected boolean removableDevice_;
    protected boolean hwSlot_;

    protected SlotInfo(CK_SLOT_INFO cK_SLOT_INFO) {
        if (cK_SLOT_INFO == null) {
            throw new NullPointerException("Argument \"ckSlotInfo\" must not be null.");
        }
        this.slotDescription_ = new String(cK_SLOT_INFO.slotDescription);
        this.manufacturerID_ = new String(cK_SLOT_INFO.manufacturerID);
        this.hardwareVersion_ = new Version(cK_SLOT_INFO.hardwareVersion);
        this.firmwareVersion_ = new Version(cK_SLOT_INFO.firmwareVersion);
        this.tokenPresent_ = (cK_SLOT_INFO.flags & 1L) != 0L;
        this.removableDevice_ = (cK_SLOT_INFO.flags & 2L) != 0L;
        this.hwSlot_ = (cK_SLOT_INFO.flags & 4L) != 0L;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SlotInfo) {
            SlotInfo slotInfo = (SlotInfo)object;
            bl = this == slotInfo || this.slotDescription_.equals(slotInfo.slotDescription_) && this.manufacturerID_.equals(slotInfo.manufacturerID_) && this.hardwareVersion_.equals(slotInfo.hardwareVersion_) && this.firmwareVersion_.equals(slotInfo.firmwareVersion_) && this.tokenPresent_ == slotInfo.tokenPresent_ && this.removableDevice_ == slotInfo.removableDevice_ && this.hwSlot_ == slotInfo.hwSlot_;
        }
        return bl;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion_;
    }

    public Version getHardwareVersion() {
        return this.hardwareVersion_;
    }

    public String getManufacturerID() {
        return this.manufacturerID_;
    }

    public String getSlotDescription() {
        return this.slotDescription_;
    }

    public int hashCode() {
        return this.slotDescription_.hashCode() ^ this.manufacturerID_.hashCode() ^ this.hardwareVersion_.hashCode() ^ this.firmwareVersion_.hashCode();
    }

    public boolean isHwSlot() {
        return this.hwSlot_;
    }

    public boolean isRemovableDevice() {
        return this.removableDevice_;
    }

    public boolean isTokenPresent() {
        return this.tokenPresent_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Slot Description: ");
        stringBuffer.append(this.slotDescription_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Manufacturer ID: ");
        stringBuffer.append(this.manufacturerID_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Hardware Version: ");
        stringBuffer.append(this.hardwareVersion_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Firmware Version: ");
        stringBuffer.append(this.firmwareVersion_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Token present: ");
        stringBuffer.append(this.tokenPresent_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Removable Device: ");
        stringBuffer.append(this.removableDevice_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Hardware Slot: ");
        stringBuffer.append(this.hwSlot_);
        return stringBuffer.toString();
    }
}

