/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.util.passphrase;

import iaik.apps.util.GridBagConstraints2;
import iaik.apps.util.passphrase.PassphrasePrompt;
import iaik.apps.util.passphrase.Util;
import iaik.pkcs.pkcs11.TokenInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public final class PassphraseFrameDialog
extends JFrame
implements PassphrasePrompt {
    private static final boolean DEBUG = true;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static ResourceBundle res_;
    protected boolean cancelAllowed_;
    protected JPanel panel1_;
    protected GridBagLayout gridBagLayout1_;
    protected JTextArea jTAMsg_;
    protected JLabel jLPassphrase_;
    protected JPasswordField jPFPassphrase_;
    protected JButton jButtonOK_;
    boolean isFirstPaint;
    protected String message_;
    protected Object protectedResourceInfo_;
    protected char[] passphrase_ = null;
    protected Object dialogClosedLock_ = new Object();
    protected boolean dialogClosed_ = false;

    static {
        try {
            res_ = ResourceBundle.getBundle("iaik.apps.util.passphrase.PassphraseDialog", Locale.getDefault());
        }
        catch (Throwable throwable) {
            System.err.println("Error loading resources:");
            throwable.printStackTrace(System.err);
        }
    }

    public PassphraseFrameDialog() {
        this(null, (Object)null);
    }

    public PassphraseFrameDialog(String string) {
        this(null, (Object)null);
    }

    public PassphraseFrameDialog(String string, Object object) {
        super(string);
        this.dialogInit();
        this.setTitle(string != null ? string : res_.getString("TITLE"));
        this.setMessage(object != null ? object.toString() : res_.getString("MESSAGE"));
        this.setCancelAllowed(true);
        this.setResizable(false);
    }

    protected void dialogInit() {
        this.panel1_ = new JPanel();
        this.gridBagLayout1_ = new GridBagLayout();
        this.jTAMsg_ = new JTextArea();
        this.jLPassphrase_ = new JLabel();
        this.jPFPassphrase_ = new JPasswordField();
        this.jButtonOK_ = new JButton();
        this.panel1_.setLayout(this.gridBagLayout1_);
        this.jTAMsg_.setEditable(false);
        this.jTAMsg_.setBackground(Color.lightGray);
        this.jLPassphrase_.setText(res_.getString("L_PASSPHRASE"));
        this.jLPassphrase_.setForeground(Color.black);
        this.jLPassphrase_.setDisplayedMnemonic(res_.getString("KEY_PASSPHRASE").charAt(0));
        this.jLPassphrase_.setLabelFor(this.jPFPassphrase_);
        this.jButtonOK_.setText(res_.getString("L_OK"));
        this.jButtonOK_.setMnemonic(res_.getString("KEY_OK").charAt(0));
        this.jPFPassphrase_.setToolTipText(res_.getString("TT_PASSPHRASE"));
        this.jPFPassphrase_.setPreferredSize(new Dimension(150, 21));
        this.getContentPane().add(this.panel1_);
        this.panel1_.add((Component)this.jTAMsg_, new GridBagConstraints2(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(20, 20, 0, 20), 0, 0));
        this.panel1_.add((Component)this.jLPassphrase_, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 20, 10, 0), 0, 0));
        this.panel1_.add((Component)this.jPFPassphrase_, new GridBagConstraints2(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 10, 20), 0, 0));
        this.panel1_.add((Component)this.jButtonOK_, new GridBagConstraints2(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 15, 0), 0, 0));
        this.jPFPassphrase_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PassphraseFrameDialog.this.okActionPerformed();
            }
        });
        this.jButtonOK_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PassphraseFrameDialog.this.okActionPerformed();
            }
        });
        Container container = this.getContentPane();
        if (container.getComponentCount() > 0) {
            container.removeAll();
        }
        container.add(this.panel1_);
        container.validate();
        this.getRootPane().setDefaultButton(this.jButtonOK_);
        this.pack();
    }

    public void dispose() {
        Object object = this.dialogClosedLock_;
        synchronized (object) {
            super.dispose();
            this.dialogClosed_ = true;
            this.dialogClosedLock_.notify();
        }
    }

    protected void fillMessage() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.message_ != null) {
            stringBuffer.append(this.message_);
        } else if (this.protectedResourceInfo_ != null) {
            stringBuffer.append(res_.getString("MESSAGE_WITH_RESOURCE"));
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append(LINE_SEPARATOR);
        } else {
            stringBuffer.append(res_.getString("MESSAGE"));
        }
        if (this.protectedResourceInfo_ != null) {
            if (this.protectedResourceInfo_ instanceof TokenInfo) {
                TokenInfo tokenInfo = (TokenInfo)this.protectedResourceInfo_;
                String string = Util.fixString(tokenInfo.getLabel());
                stringBuffer.append(string);
            } else {
                stringBuffer.append(this.protectedResourceInfo_.toString());
            }
        }
        this.jTAMsg_.setText(stringBuffer.toString());
        this.pack();
    }

    public char[] getPassphrase() {
        char[] cArray = this.passphrase_;
        this.passphrase_ = null;
        return cArray;
    }

    public boolean isCancelAllowed() {
        return this.cancelAllowed_;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Warning: Could not set look and feel:");
            System.err.println(exception);
        }
        PassphraseFrameDialog passphraseFrameDialog = new PassphraseFrameDialog();
        passphraseFrameDialog.show();
        JOptionPane.showMessageDialog(null, new String(passphraseFrameDialog.getPassphrase()));
        System.exit(0);
    }

    private void okActionPerformed() {
        Object object = this.dialogClosedLock_;
        synchronized (object) {
            if (this.passphrase_ == null) {
                char[] cArray = this.jPFPassphrase_.getPassword();
                this.passphrase_ = new char[cArray.length];
                System.arraycopy(cArray, 0, this.passphrase_, 0, cArray.length);
                int n2 = 0;
                while (n2 < cArray.length) {
                    cArray[n2] = '\u0000';
                    ++n2;
                }
                ((JTextComponent)this.jPFPassphrase_).setText("");
            }
            this.dialogClosed_ = true;
            this.dialogClosedLock_.notify();
            this.hide();
        }
    }

    public void paint(Graphics graphics) {
        if (this.isFirstPaint) {
            if (!this.jPFPassphrase_.hasFocus()) {
                this.jPFPassphrase_.requestFocus();
            }
            this.isFirstPaint = false;
        }
        super.paint(graphics);
    }

    public char[] promptPassphrase() {
        this.show();
        return this.getPassphrase();
    }

    public synchronized void setCancelAllowed(boolean bl) {
        this.cancelAllowed_ = bl;
        if (bl) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(0);
        }
    }

    public void setMessage(Object object) {
        this.message_ = object != null ? object.toString() : null;
        this.fillMessage();
    }

    public void setProtectedResourceInfo(Object object) {
        this.protectedResourceInfo_ = object;
        this.fillMessage();
    }

    public void show() {
        Object object = this.dialogClosedLock_;
        synchronized (object) {
            this.isFirstPaint = true;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
            super.show();
            try {
                while (!this.dialogClosed_) {
                    this.dialogClosedLock_.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                Thread.currentThread().interrupt();
            }
            this.dialogClosed_ = false;
            super.hide();
        }
    }
}

