/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.util.passphrase;

import iaik.apps.util.GridBagConstraints2;
import iaik.apps.util.passphrase.NewPassphrasePrompt;
import iaik.apps.util.passphrase.PassphraseConstraints;
import iaik.apps.util.passphrase.PassphraseException;
import iaik.apps.util.passphrase.Util;
import iaik.pkcs.pkcs11.TokenInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public final class NewPassphraseDialog
extends JDialog
implements NewPassphrasePrompt {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected JPanel panel1_;
    protected GridBagLayout gridBagLayout1_;
    protected JTextArea jTAMsg_;
    protected JLabel jLPassphrase_;
    protected JLabel jLOldPassphrase_;
    protected JLabel jLConfirmation_;
    protected JPasswordField jPFOldPassphrase_;
    protected JPasswordField jPFPassphrase_;
    protected JPasswordField jPFConfirmation_;
    protected JButton jButtonOK_;
    protected JFrame dummyOwner_;
    boolean isFirstPaint;
    protected String title_;
    protected String message_;
    protected Object protectedResourceInfo_;
    protected char[] oldPassphrase_ = null;
    protected char[] passphrase_ = null;
    protected PassphraseConstraints cons_;
    protected static ResourceBundle res_;
    protected boolean cancelAllowed_;
    protected boolean oldPassphraseRequired_;

    static {
        try {
            res_ = ResourceBundle.getBundle("iaik.apps.util.passphrase.NewPassphraseDialog", Locale.getDefault());
        }
        catch (Throwable throwable) {
            System.err.println("Error loading resources:");
            throwable.printStackTrace(System.err);
        }
    }

    public NewPassphraseDialog() {
        this((Frame)new JFrame(), null, (Object)null);
    }

    public NewPassphraseDialog(Frame frame) {
        this(frame, null, (Object)null);
    }

    public NewPassphraseDialog(Frame frame, String string) {
        this(frame, string, (Object)null);
    }

    public NewPassphraseDialog(Frame frame, String string, Object object) {
        super(frame, string, true);
        this.setTitle(string != null ? string : res_.getString("TITLE"));
        this.setMessage(object != null ? object.toString() : res_.getString("MESSAGE"));
        this.setConstraints(null);
        this.setCancelAllowed(true);
        this.setResizable(false);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        } else {
            this.dummyOwner_ = new JFrame("Password Dialog");
            ((Component)this.dummyOwner_).setLocation(-1000, -1000);
            this.dummyOwner_.setDefaultCloseOperation(2);
        }
    }

    public NewPassphraseDialog(String string) {
        this((Frame)new JFrame(), string, (Object)null);
    }

    public NewPassphraseDialog(String string, Object object) {
        this((Frame)new JFrame(), string, object);
    }

    protected void checkPassphrase() throws PassphraseException {
        char[] cArray = this.jPFPassphrase_.getPassword();
        if (!this.equals(cArray, this.jPFConfirmation_.getPassword())) {
            throw new PassphraseException(res_.getString("MSG_NOT_EQUAL"));
        }
        String string = this.cons_.isPassphraseValid(cArray);
        if (string != null) {
            throw new PassphraseException(string);
        }
    }

    protected void dialogInit() {
        this.gridBagLayout1_ = new GridBagLayout();
        this.jTAMsg_ = new JTextArea();
        this.jLPassphrase_ = new JLabel();
        this.jLOldPassphrase_ = new JLabel();
        this.jLConfirmation_ = new JLabel();
        this.jPFOldPassphrase_ = new JPasswordField();
        this.jPFPassphrase_ = new JPasswordField();
        this.jPFConfirmation_ = new JPasswordField();
        this.jButtonOK_ = new JButton();
        super.dialogInit();
        this.jTAMsg_.setEditable(false);
        this.jTAMsg_.setBackground(Color.lightGray);
        this.jLPassphrase_.setText(res_.getString("L_PASSPHRASE"));
        this.jLPassphrase_.setForeground(Color.black);
        this.jLPassphrase_.setDisplayedMnemonic(res_.getString("KEY_PASSPHRASE").charAt(0));
        this.jLPassphrase_.setLabelFor(this.jPFPassphrase_);
        this.jLConfirmation_.setText(res_.getString("L_CONFIRMATION"));
        this.jLConfirmation_.setForeground(Color.black);
        this.jLConfirmation_.setDisplayedMnemonic(res_.getString("KEY_CONFIRMATION").charAt(0));
        this.jLConfirmation_.setLabelFor(this.jPFConfirmation_);
        this.jButtonOK_.setText(res_.getString("L_OK"));
        this.jButtonOK_.setMnemonic(res_.getString("KEY_OK").charAt(0));
        this.jPFPassphrase_.setToolTipText(res_.getString("TT_PASSPHRASE"));
        this.jPFPassphrase_.setPreferredSize(new Dimension(150, 21));
        this.jPFConfirmation_.setToolTipText(res_.getString("TT_CONFIRMATION"));
        this.jPFConfirmation_.setPreferredSize(new Dimension(150, 21));
        this.jPFOldPassphrase_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewPassphraseDialog.this.jPFPassphrase_.requestFocus();
            }
        });
        this.jPFPassphrase_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewPassphraseDialog.this.jPFConfirmation_.requestFocus();
            }
        });
        this.jPFConfirmation_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewPassphraseDialog.this.okActionPerformed();
            }
        });
        this.jButtonOK_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewPassphraseDialog.this.okActionPerformed();
            }
        });
        this.oldPassphraseRequired_ = true;
        this.initContentPane();
    }

    protected void displayError(String string) {
        JOptionPane.showMessageDialog(this, string, res_.getString("TITLE_ERROR"), 0);
    }

    protected boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] != cArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void fill(char[] cArray, char c2) {
        if (cArray == null || cArray.length == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = c2;
            ++n2;
        }
    }

    protected void fillMessage() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.message_ != null) {
            stringBuffer.append(this.message_);
        } else if (this.protectedResourceInfo_ != null) {
            stringBuffer.append(res_.getString("MESSAGE_WITH_RESOURCE"));
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append(LINE_SEPARATOR);
        } else {
            stringBuffer.append(res_.getString("MESSAGE"));
        }
        if (this.protectedResourceInfo_ != null) {
            if (this.protectedResourceInfo_ instanceof TokenInfo) {
                TokenInfo tokenInfo = (TokenInfo)this.protectedResourceInfo_;
                String string = Util.fixString(tokenInfo.getLabel());
                stringBuffer.append(string);
            } else {
                stringBuffer.append(this.protectedResourceInfo_.toString());
            }
        }
        this.jTAMsg_.setText(stringBuffer.toString());
        this.pack();
    }

    public char[] getNewPassphrase() {
        char[] cArray = this.passphrase_;
        this.passphrase_ = null;
        return cArray;
    }

    public char[] getOldPassphrase() {
        char[] cArray = this.oldPassphrase_;
        this.oldPassphrase_ = null;
        return cArray;
    }

    protected void initContentPane() {
        this.panel1_ = new JPanel();
        this.panel1_.setLayout(this.gridBagLayout1_);
        if (this.oldPassphraseRequired_) {
            this.jLOldPassphrase_.setText(res_.getString("L_OLD_PASSPHRASE"));
            this.jLOldPassphrase_.setForeground(Color.black);
            this.jLOldPassphrase_.setDisplayedMnemonic(res_.getString("KEY_OLD_PASSPHRASE").charAt(0));
            this.jLOldPassphrase_.setLabelFor(this.jPFOldPassphrase_);
            this.jPFOldPassphrase_.setToolTipText(res_.getString("TT_OLD_PASSPHRASE"));
            this.jPFOldPassphrase_.setPreferredSize(new Dimension(150, 21));
            this.panel1_.add((Component)this.jLOldPassphrase_, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 20, 0, 0), 0, 0));
            this.panel1_.add((Component)this.jLPassphrase_, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 20, 0, 0), 0, 0));
            this.panel1_.add((Component)this.jTAMsg_, new GridBagConstraints2(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(20, 20, 0, 20), 0, 0));
            this.panel1_.add((Component)this.jLConfirmation_, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 20, 20, 0), 0, 0));
            this.panel1_.add((Component)this.jPFOldPassphrase_, new GridBagConstraints2(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 0, 20), 0, 0));
            this.panel1_.add((Component)this.jPFPassphrase_, new GridBagConstraints2(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 20), 0, 0));
            this.panel1_.add((Component)this.jPFConfirmation_, new GridBagConstraints2(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 20, 20), 0, 0));
            this.panel1_.add((Component)this.jButtonOK_, new GridBagConstraints2(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 15, 0), 0, 0));
        } else {
            this.panel1_.add((Component)this.jLPassphrase_, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 20, 0, 0), 0, 0));
            this.panel1_.add((Component)this.jTAMsg_, new GridBagConstraints2(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(20, 20, 0, 20), 0, 0));
            this.panel1_.add((Component)this.jLConfirmation_, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 20, 20, 0), 0, 0));
            this.panel1_.add((Component)this.jPFPassphrase_, new GridBagConstraints2(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 0, 20), 0, 0));
            this.panel1_.add((Component)this.jPFConfirmation_, new GridBagConstraints2(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 20, 20), 0, 0));
            this.panel1_.add((Component)this.jButtonOK_, new GridBagConstraints2(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 15, 0), 0, 0));
        }
        Container container = this.getContentPane();
        if (container.getComponentCount() > 0) {
            container.removeAll();
        }
        container.add(this.panel1_);
        container.validate();
        this.getRootPane().setDefaultButton(this.jButtonOK_);
        this.pack();
    }

    public boolean isCancelAllowed() {
        return this.cancelAllowed_;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Warning: Could not set look and feel:");
            System.err.println(exception);
        }
        NewPassphraseDialog newPassphraseDialog = new NewPassphraseDialog();
        newPassphraseDialog.show();
        char[] cArray = newPassphraseDialog.getNewPassphrase();
        JOptionPane.showMessageDialog(null, cArray != null ? new String(cArray) : null);
        System.exit(0);
    }

    protected void okActionPerformed() {
        try {
            this.checkPassphrase();
        }
        catch (PassphraseException passphraseException) {
            this.displayError(passphraseException.getMessage());
            this.jPFPassphrase_.requestFocus();
            return;
        }
        this.retrievePassphrase();
        this.hide();
    }

    public void paint(Graphics graphics) {
        if (this.isFirstPaint) {
            if (this.oldPassphraseRequired_) {
                if (!this.jPFOldPassphrase_.hasFocus()) {
                    this.jPFOldPassphrase_.requestFocus();
                }
            } else if (!this.jPFPassphrase_.hasFocus()) {
                this.jPFPassphrase_.requestFocus();
            }
            this.isFirstPaint = false;
        }
        super.paint(graphics);
    }

    public char[][] promptNewPassphrase() {
        this.show();
        char[] cArray = this.getNewPassphrase();
        char[][] cArray2 = cArray != null ? new char[][]{this.getOldPassphrase(), cArray} : null;
        return cArray2;
    }

    protected void retrievePassphrase() {
        this.oldPassphrase_ = this.jPFOldPassphrase_.getPassword();
        ((JTextComponent)this.jPFOldPassphrase_).setText("");
        this.passphrase_ = this.jPFPassphrase_.getPassword();
        ((JTextComponent)this.jPFPassphrase_).setText("");
        this.fill(this.jPFConfirmation_.getPassword(), '\u0000');
        ((JTextComponent)this.jPFConfirmation_).setText("");
    }

    public synchronized void setCancelAllowed(boolean bl) {
        this.cancelAllowed_ = bl;
        if (bl) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(0);
        }
    }

    public void setConstraints(PassphraseConstraints passphraseConstraints) {
        this.cons_ = passphraseConstraints != null ? passphraseConstraints : new DefaultConstraints();
    }

    public void setMessage(Object object) {
        this.message_ = object != null ? object.toString() : null;
        this.fillMessage();
    }

    public void setOldPassphraseRequired(boolean bl) {
        this.oldPassphraseRequired_ = bl;
        this.panel1_ = null;
    }

    public void setProtectedResourceInfo(Object object) {
        this.protectedResourceInfo_ = object;
        this.fillMessage();
    }

    public void show() {
        this.isFirstPaint = true;
        if (this.panel1_ == null) {
            this.initContentPane();
        }
        if (this.dummyOwner_ != null) {
            this.dummyOwner_.show();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.show();
    }

    protected class DefaultConstraints
    implements PassphraseConstraints {
        protected DefaultConstraints() {
        }

        public String isPassphraseValid(char[] cArray) {
            return null;
        }
    }
}

