/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.service;

import java.math.BigDecimal;
import org.cocktail.pieFwk.common.metier.Prestation;
import org.cocktail.pieFwk.common.metier.PrestationLigne;
import org.cocktail.pieFwk.common.service.AbstractFacturationService;

public class PrestationLigneService
extends AbstractFacturationService {
    private static final PrestationLigneService INSTANCE = new PrestationLigneService();

    public static PrestationLigneService instance() {
        return INSTANCE;
    }

    private PrestationLigneService() {
    }

    public BigDecimal getRemiseGlobale(PrestationLigne ligne) {
        if (ligne == null || ligne.getPrestationCommon() == null) {
            return null;
        }
        return ligne.getPrestationCommon().remiseGlobale();
    }

    public BigDecimal calculerMontantTotalHTRemiseIncluse(PrestationLigne ligne) {
        BigDecimal articleHT = ligne.prligArtHt();
        BigDecimal quantite = ligne.prligQuantite();
        Integer nbDecimales = this.determineNombreDecimalesImposees(ligne);
        BigDecimal montantTotalHTExact = this.calculerMontantTotalHTExact(articleHT, quantite);
        return this.applyRemise(montantTotalHTExact, this.getRemiseGlobale(ligne)).setScale((int)nbDecimales, 4);
    }

    public BigDecimal calculerMontantTotalTTCRemiseIncluse(PrestationLigne ligne, BigDecimal montantHT, BigDecimal montantTTC, BigDecimal quantite) {
        int nbDecimalesImposees = this.determineNombreDecimalesImposees(ligne);
        BigDecimal tauxTvaSiPresent = null;
        if (ligne != null) {
            tauxTvaSiPresent = ligne.companion().tauxTvaCatalogueArticle();
        }
        BigDecimal totalTTExact = this.calculerMontantTotalTTCExact(montantHT, montantTTC, quantite, tauxTvaSiPresent);
        return this.applyRemise(totalTTExact, this.getRemiseGlobale(ligne)).setScale(nbDecimalesImposees, 4);
    }

    public int determineNombreDecimalesImposees(PrestationLigne ligne) {
        return this.determineNombreDecimalesImposees(ligne.applicationConfig(), ligne.editingContext(), ligne.exerciceAsNumber());
    }

    public int determineNombreDecimalesImposees(Prestation prestation) {
        return this.determineNombreDecimalesImposees(prestation.applicationConfig(), prestation.editingContext(), prestation.exerciceAsNumber());
    }
}

