/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.service;

import java.math.BigDecimal;
import org.cocktail.pieFwk.common.metier.CatalogueArticle;
import org.cocktail.pieFwk.common.metier.FacturePapier;
import org.cocktail.pieFwk.common.metier.FacturePapierLigne;
import org.cocktail.pieFwk.common.service.AbstractFacturationService;

public class FacturePapierLigneService
extends AbstractFacturationService {
    private static final FacturePapierLigneService INSTANCE = new FacturePapierLigneService();

    public static FacturePapierLigneService instance() {
        return INSTANCE;
    }

    private FacturePapierLigneService() {
    }

    public BigDecimal getRemiseGlobale(FacturePapierLigne ligne) {
        if (ligne == null || ligne.getFacturePapierCommon() == null) {
            return null;
        }
        return ligne.getFacturePapierCommon().remiseGlobale();
    }

    public BigDecimal calculerMontantTotalHTRemiseIncluse(FacturePapierLigne ligneFacture) {
        BigDecimal articleHT = ligneFacture.fligArtHt();
        BigDecimal quantite = ligneFacture.fligQuantite();
        int nbDecimales = this.determineNombreDecimalesImposees(ligneFacture);
        BigDecimal montantTotalHTExact = this.calculerMontantTotalHTExact(articleHT, quantite);
        return this.applyRemise(montantTotalHTExact, this.getRemiseGlobale(ligneFacture)).setScale(nbDecimales, 4);
    }

    public BigDecimal calculerMontantTotalTTCRemiseIncluse(FacturePapierLigne ligneFacture) {
        BigDecimal articleHT = ligneFacture.fligArtHt();
        BigDecimal articleTTC = ligneFacture.fligArtTtc();
        BigDecimal quantite = ligneFacture.fligQuantite();
        BigDecimal tauxTvaSiPresent = this.getTauxTva(ligneFacture);
        int nbDecimales = this.determineNombreDecimalesImposees(ligneFacture);
        BigDecimal totalTTExact = this.calculerMontantTotalTTCExact(articleHT, articleTTC, quantite, tauxTvaSiPresent);
        return this.applyRemise(totalTTExact, this.getRemiseGlobale(ligneFacture)).setScale(nbDecimales, 4);
    }

    public BigDecimal getTauxTva(FacturePapierLigne ligneFacture) {
        if (ligneFacture != null && ligneFacture.tauxTva() != null) {
            return ligneFacture.tauxTva().tauxTVA();
        }
        CatalogueArticle catalogueArticle = this.catalogueArticle(ligneFacture);
        if (catalogueArticle != null) {
            return catalogueArticle.tauxTVA();
        }
        return null;
    }

    protected CatalogueArticle catalogueArticle(FacturePapierLigne ligne) {
        if (ligne == null || ligne.getPrestationLigneCommon() == null || ligne.getPrestationLigneCommon().getCatalogueArticleCommon() == null) {
            return null;
        }
        return ligne.getPrestationLigneCommon().getCatalogueArticleCommon();
    }

    public int determineNombreDecimalesImposees(FacturePapierLigne ligne) {
        return this.determineNombreDecimalesImposees(ligne.applicationConfig(), ligne.editingContext(), ligne.exerciceAsNumber());
    }

    public int determineNombreDecimalesImposees(FacturePapier facturePapier) {
        return this.determineNombreDecimalesImposees(facturePapier.applicationConfig(), facturePapier.editingContext(), facturePapier.exerciceAsNumber());
    }
}

