/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.service;

import com.webobjects.eocontrol.EOEditingContext;
import java.math.BigDecimal;
import org.cocktail.pieFwk.common.ApplicationConfig;
import org.cocktail.pieFwk.common.metier.CatalogueArticle;
import org.cocktail.pieFwk.common.service.FacturationService;

public abstract class AbstractFacturationService
implements FacturationService {
    public static final int ZERO_DECIMALE = 0;
    public static final int DEUX_DECIMALES = 2;
    public static final int NB_DECIMALES_TAUX_TVA = 3;
    public static final BigDecimal TAUX_TVA_PAR_DEFAUT = BigDecimal.ONE;
    public static final BigDecimal POURCENTAGE_100 = BigDecimal.valueOf(100.0);

    public BigDecimal calculerMontantTotalHTExact(BigDecimal produitHT, BigDecimal quantite) {
        return produitHT.multiply(quantite);
    }

    public BigDecimal calculerMontantTotalTTCExact(BigDecimal produitHT, BigDecimal produitTTC, BigDecimal quantite, BigDecimal tauxTVAEnPourcent) {
        BigDecimal montantTotalTTCExact = null;
        if (this.isCalculTotalTTCPossibleAvecHTCommeBaseCalcul(produitHT, produitTTC, quantite)) {
            montantTotalTTCExact = this.calculerMontantTotalTTCRemiseIncluseAvecBaseHT(produitHT, produitTTC, quantite, tauxTVAEnPourcent);
        } else if (this.isCalculTotalTTCAvecTVACommeBaseCalcul(produitHT, produitTTC, quantite)) {
            montantTotalTTCExact = this.calculerMontantTotalTTCRemiseIncluseAvecBaseTVA(produitHT, produitTTC, quantite, tauxTVAEnPourcent);
        }
        return montantTotalTTCExact;
    }

    protected BigDecimal calculerMontantTotalTTCRemiseIncluseAvecBaseHT(BigDecimal produitHT, BigDecimal produitTTC, BigDecimal quantite, BigDecimal tauxTVAEnPourcent) {
        BigDecimal totalHTExact = this.calculerMontantTotalHTExact(produitHT, quantite);
        BigDecimal tauxTva = null;
        tauxTva = tauxTVAEnPourcent != null ? this.calculerTauxTva(tauxTVAEnPourcent, 3) : this.calculerTauxTva(produitHT, produitTTC, 3, TAUX_TVA_PAR_DEFAUT);
        return totalHTExact.multiply(tauxTva);
    }

    protected BigDecimal calculerMontantTotalTTCRemiseIncluseAvecBaseTVA(BigDecimal produitHT, BigDecimal produitTTC, BigDecimal quantite, BigDecimal tauxTVAEnPourcent) {
        return produitTTC.multiply(quantite);
    }

    public BigDecimal applyRemise(BigDecimal montant, BigDecimal remiseGlobaleEnPourcent) {
        return this.applyRemise(montant, remiseGlobaleEnPourcent, null);
    }

    public BigDecimal applyRemise(BigDecimal montant, BigDecimal remiseGlobaleEnPourcent, Integer nbDecimales) {
        if (montant == null) {
            return BigDecimal.ZERO;
        }
        int nbDecimalesImposees = montant.scale();
        if (nbDecimales != null) {
            nbDecimalesImposees = nbDecimales;
        }
        if (remiseGlobaleEnPourcent == null) {
            return montant.setScale(nbDecimalesImposees, 4);
        }
        return montant.subtract(montant.multiply(remiseGlobaleEnPourcent.divide(new BigDecimal(100.0), 4))).setScale(nbDecimalesImposees, 4);
    }

    public BigDecimal calculerTauxTva(BigDecimal mtHT, BigDecimal mtTTC, int scale, BigDecimal tauxTvaParDefaut) {
        BigDecimal tauxTva = tauxTvaParDefaut;
        if (this.estDivisible(mtHT)) {
            tauxTva = mtTTC.divide(mtHT, scale, 4).setScale(scale, 4);
        }
        return tauxTva;
    }

    public int determineNombreDecimalesImposees(ApplicationConfig config, EOEditingContext edc, Number exercice) {
        Integer nbDecimales = config.nbDecimalesImposees(edc, exercice);
        if (nbDecimales == null) {
            nbDecimales = 2;
        }
        return nbDecimales;
    }

    protected BigDecimal calculerTauxTva(BigDecimal tauxTvaEnPourcent, int scale) {
        return tauxTvaEnPourcent.divide(POURCENTAGE_100, scale, 4).add(BigDecimal.ONE);
    }

    protected boolean tauxTVACatalogueDisponible(CatalogueArticle catalogueArticle) {
        return catalogueArticle != null && catalogueArticle.tauxTVA() != null;
    }

    protected boolean estDivisible(BigDecimal montant) {
        return montant != null && montant.doubleValue() > 0.0;
    }

    protected boolean isCalculPossible(BigDecimal montantHT, BigDecimal montantTTC, BigDecimal quantite) {
        return montantHT != null && montantTTC != null && quantite != null;
    }

    protected boolean isCalculTotalTTCPossibleAvecHTCommeBaseCalcul(BigDecimal montantHT, BigDecimal montantTTC, BigDecimal quantite) {
        return this.isCalculPossible(montantHT, montantTTC, quantite) && montantHT.doubleValue() != 0.0;
    }

    protected boolean isCalculTotalTTCAvecTVACommeBaseCalcul(BigDecimal montantHT, BigDecimal montantTTC, BigDecimal quantite) {
        return this.isCalculPossible(montantHT, montantTTC, quantite) && montantHT.doubleValue() == 0.0 && montantTTC.doubleValue() > 0.0;
    }
}

