/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.metier;

import com.webobjects.foundation.NSArray;
import java.math.BigDecimal;
import org.cocktail.pieFwk.common.metier.Prestation;
import org.cocktail.pieFwk.common.metier.PrestationLigne;
import org.cocktail.pieFwk.common.service.PrestationLigneService;

public class PrestationCompanion {
    private Prestation prestation;
    private PrestationLigneService ligneService;

    public PrestationCompanion(Prestation prestation) {
        this.prestation = prestation;
        this.ligneService = PrestationLigneService.instance();
    }

    public BigDecimal totalHTLive() {
        if (this.prestationLignes() == null || this.prestationLignes().count() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalLive = BigDecimal.ZERO;
        int idx = 0;
        while (idx < this.prestationLignes().count()) {
            PrestationLigne ligne = (PrestationLigne)this.prestationLignes().objectAtIndex(idx);
            BigDecimal ligneTotalHT = this.ligneService().calculerMontantTotalHTExact(ligne.prligArtHt(), ligne.prligQuantite());
            totalLive = totalLive.add(ligneTotalHT);
            ++idx;
        }
        return this.ligneService().applyRemise(totalLive, this.prestation().remiseGlobale(), this.ligneService().determineNombreDecimalesImposees(this.prestation()));
    }

    public BigDecimal totalTTCLive() {
        if (this.prestationLignes() == null || this.prestationLignes().count() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalLive = BigDecimal.ZERO;
        int idx = 0;
        while (idx < this.prestationLignes().count()) {
            PrestationLigne ligne = (PrestationLigne)this.prestationLignes().objectAtIndex(idx);
            BigDecimal ligneTotalTTC = this.ligneService().calculerMontantTotalTTCExact(ligne.prligArtHt(), ligne.prligArtTtc(), ligne.prligQuantite(), ligne.companion().tauxTvaCatalogueArticle());
            totalLive = totalLive.add(ligneTotalTTC);
            ++idx;
        }
        return this.ligneService().applyRemise(totalLive, this.prestation().remiseGlobale(), this.ligneService().determineNombreDecimalesImposees(this.prestation()));
    }

    public BigDecimal totalTVALive() {
        return this.totalTTCLive().subtract(this.totalHTLive());
    }

    public void updateTotaux() {
        BigDecimal totalHTLive = this.totalHTLive();
        BigDecimal totalTTCLive = this.totalTTCLive();
        BigDecimal totalTVALive = totalTTCLive.subtract(totalHTLive);
        this.prestation().setTotalHT(totalHTLive);
        this.prestation().setTotalTVA(totalTVALive);
        this.prestation().setTotalTTC(totalTTCLive);
    }

    public Prestation prestation() {
        return this.prestation;
    }

    public NSArray prestationLignes() {
        if (this.prestation() == null) {
            return new NSArray();
        }
        return this.prestation().getPrestationLignesCommon();
    }

    public PrestationLigneService ligneService() {
        return this.ligneService;
    }
}

