/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.service;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSTimestamp;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Iterator;
import org.cocktail.kava.client.finder.FinderFournisseurAdresse;
import org.cocktail.kava.client.metier.EOAdresse;
import org.cocktail.kava.client.metier.EOFournisUlr;
import org.cocktail.kava.client.metier.EOPersonne;
import org.cocktail.kava.client.metier.EORepartPersonneAdresse;
import org.cocktail.kava.client.qualifier.Qualifiers;

public class PersonneService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final PersonneService INSTANCE = new PersonneService();

    public static final PersonneService instance() {
        return INSTANCE;
    }

    private PersonneService() {
    }

    public EORepartPersonneAdresse defaultAdress(EOEditingContext ec, EOPersonne personne) {
        if (personne == null) {
            return null;
        }
        EORepartPersonneAdresse defaultAdress = null;
        NSArray repartPersonneAdresses = personne.repartPersonneAdresses();
        NSArray fournisUlr = personne.fournisUlrs();
        if (fournisUlr != null && fournisUlr.count() == 1) {
            EOAdresse fournisAdress = FinderFournisseurAdresse.findAdresse(ec, (EOFournisUlr)((Object)fournisUlr.objectAtIndex(0)));
            defaultAdress = this.findMatch(repartPersonneAdresses, fournisAdress);
        } else if (repartPersonneAdresses != null && repartPersonneAdresses.count() > 0) {
            EOQualifier factQual = Qualifiers.getQualifierFactory(Qualifiers.QualifierKey.REPART_PRS_ADR_TYPE).build(EOQualifier.QualifierOperatorEqual, "FACT");
            NSArray facturationAdresses = EOQualifier.filteredArrayWithQualifier((NSArray)repartPersonneAdresses, (EOQualifier)factQual);
            if (facturationAdresses.count() == 1) {
                defaultAdress = (EORepartPersonneAdresse)((Object)facturationAdresses.objectAtIndex(0));
            } else if (facturationAdresses.count() > 1) {
                NSArray factPrincipaleAdresses = this.selectAdressePrincipale(facturationAdresses);
                if (factPrincipaleAdresses.count() == 1) {
                    defaultAdress = (EORepartPersonneAdresse)((Object)facturationAdresses.objectAtIndex(0));
                } else {
                    NSArray currentAdresses = factPrincipaleAdresses.count() == 0 ? facturationAdresses : factPrincipaleAdresses;
                    defaultAdress = this.selectMostRecent(currentAdresses);
                }
            } else {
                NSArray principaleAdresses = this.selectAdressePrincipale(repartPersonneAdresses);
                if (principaleAdresses.count() == 1) {
                    defaultAdress = (EORepartPersonneAdresse)((Object)principaleAdresses.objectAtIndex(0));
                } else {
                    NSArray currentAdresses = principaleAdresses.count() == 0 ? repartPersonneAdresses : principaleAdresses;
                    defaultAdress = this.selectMostRecent(currentAdresses);
                }
            }
        }
        return defaultAdress;
    }

    private EORepartPersonneAdresse findMatch(NSArray rptAdresses, EOAdresse adresse) {
        EORepartPersonneAdresse resultRptAdresse = null;
        int idx = 0;
        while (idx < rptAdresses.count()) {
            EORepartPersonneAdresse currentRptAdr = (EORepartPersonneAdresse)((Object)rptAdresses.objectAtIndex(idx));
            if (currentRptAdr.adresse().equals((Object)adresse)) {
                resultRptAdresse = currentRptAdr;
                break;
            }
            ++idx;
        }
        return resultRptAdresse;
    }

    private NSArray selectAdressePrincipale(NSArray repartPrsAdresses) {
        EOQualifier principaleQual = Qualifiers.getQualifierFactory(Qualifiers.QualifierKey.REPART_PRS_ADR_PRINCIPALE).build(EOQualifier.QualifierOperatorEqual, "O");
        return EOQualifier.filteredArrayWithQualifier((NSArray)repartPrsAdresses, (EOQualifier)principaleQual);
    }

    private EORepartPersonneAdresse selectMostRecent(NSArray repartPrsAdresses) {
        Iterator iteAdr = repartPrsAdresses.iterator();
        EORepartPersonneAdresse mostRecentRepartAdresse = (EORepartPersonneAdresse)((Object)iteAdr.next());
        while (iteAdr.hasNext()) {
            EORepartPersonneAdresse currentRepartAdresse = (EORepartPersonneAdresse)((Object)iteAdr.next());
            NSTimestamp currentRptAdrCreation = currentRepartAdresse.adresse().dCreation();
            if (currentRptAdrCreation == null || !currentRptAdrCreation.after((Timestamp)mostRecentRepartAdresse.adresse().dCreation())) continue;
            mostRecentRepartAdresse = currentRepartAdresse;
        }
        return mostRecentRepartAdresse;
    }
}

