/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.selector;

import org.cocktail.kava.client.metier.EOFournisUlr;
import org.cocktail.kava.client.selector.FournisseurEtatControle;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FournisseurEtatControleTest {
    @Test
    public void testControlerNull() {
        FournisseurEtatControle filtreFournisseurValide = new FournisseurEtatControle("O");
        boolean controle = filtreFournisseurValide.controler(null);
        Assert.assertFalse((boolean)controle);
    }

    @Test
    public void testControler() {
        FournisseurEtatControle filtreFournisseurValide = new FournisseurEtatControle("O");
        EOFournisUlr fournisseurValide = this.buildFournisseur("O", true);
        EOFournisUlr fournisseurEnAttente = this.buildFournisseur("N", true);
        EOFournisUlr fournisseurInvalide = this.buildFournisseur("A", true);
        boolean controle = filtreFournisseurValide.controler(fournisseurValide);
        Assert.assertTrue((boolean)controle);
        controle = filtreFournisseurValide.controler(fournisseurEnAttente);
        Assert.assertFalse((boolean)controle);
        controle = filtreFournisseurValide.controler(fournisseurInvalide);
        Assert.assertFalse((boolean)controle);
    }

    private EOFournisUlr buildFournisseur(String etatFournisseur, boolean valide) {
        EOFournisUlr fournisseur = (EOFournisUlr)((Object)Mockito.mock(EOFournisUlr.class));
        Mockito.when((Object)fournisseur.isEtat(etatFournisseur)).thenReturn((Object)valide);
        return fournisseur;
    }
}

