/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.procedures;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import org.cocktail.kava.client.ServerProxy;
import org.cocktail.kava.client.metier.EORecette;
import org.cocktail.kava.client.metier.EORecetteCtrlAction;
import org.cocktail.kava.client.metier.EORecetteCtrlAnalytique;
import org.cocktail.kava.client.metier.EORecetteCtrlConvention;
import org.cocktail.kava.client.metier.EORecetteCtrlPlanco;
import org.cocktail.kava.client.metier.EORecetteCtrlPlancoCtp;
import org.cocktail.kava.client.metier.EORecetteCtrlPlancoTva;
import org.cocktail.kava.client.metier.EORecettePapierAdrClient;

public class UpdFactureRecette {
    public static void save(EOEditingContext ec, EORecette recette, Number recId) throws Exception {
        if (recette == null) {
            throw new Exception("Facture-Recette a modifier null!!");
        }
        if (recId == null) {
            throw new Exception("cle de Facture-Recette (recId) a modifier null!!");
        }
        recette.validateObjectMetierWithFacture();
        ServerProxy.apiUpdFactureRecette(ec, UpdFactureRecette.dico(ec, recette, recId));
    }

    public static void saveWithAddress(EOEditingContext ec, EORecette recette, Number recId) throws Exception {
        if (recette == null) {
            throw new Exception("Facture-Recette a modifier null!!");
        }
        if (recId == null) {
            throw new Exception("cle de Facture-Recette (recId) a modifier null!!");
        }
        recette.validateObjectMetierWithFacture();
        ServerProxy.apiUpdFactureRecetteAdresse(ec, UpdFactureRecette.dico(ec, recette, recId));
    }

    protected static NSDictionary dico(EOEditingContext ec, EORecette recette, Number recId) throws Exception {
        NSMutableDictionary dico = new NSMutableDictionary();
        NSDictionary dicoForPrimaryKeys = null;
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"facId"), "010aFacId");
        dico.takeValueForKey((Object)recId, "020aRecId");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.exercice());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"exeOrdre"), "030aExeOrdre");
        dico.takeValueForKey((Object)recette.facture().facNumero(), "040aFacNumero");
        dico.takeValueForKey((Object)recette.recNumero(), "050aRecNumero");
        if (recette.facture().fournisUlr() != null) {
            dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().fournisUlr());
            dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"fouOrdre"), "060aFouOrdre");
        } else {
            dico.takeValueForKey(null, "060aFouOrdre");
        }
        if (recette.facture().personne() != null) {
            dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().personne());
            dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"persId"), "070aPersId");
        } else {
            dico.takeValueForKey(null, "070aPersId");
        }
        dico.takeValueForKey((Object)recette.recLib(), "080aFacLib");
        if (recette.recettePapier() != null && recette.recettePapier().ribfourUlr() != null) {
            dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.recettePapier().ribfourUlr());
            dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"ribOrdre"), "085aRibOrdre");
        } else {
            dico.takeValueForKey(null, "085aRibOrdre");
        }
        if (recette.recettePapier() != null && recette.recettePapier().modeRecouvrement() != null) {
            dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.recettePapier().modeRecouvrement());
            dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"modOrdre"), "090aMorOrdre");
        } else {
            dico.takeValueForKey(null, "090aMorOrdre");
        }
        dico.takeValueForKey((Object)recette.recettePapier().rppNbPiece(), "095aRppNbPiece");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().organ());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"orgId"), "100aOrgId");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().typeCreditRec());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"tcdOrdre"), "110aTcdOrdre");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.tauxProrata());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"tapId"), "120aTapId");
        dico.takeValueForKey((Object)recette.recHtSaisie(), "130aFacHtSaisie");
        dico.takeValueForKey((Object)recette.recTtcSaisie(), "140aFacTtcSaisie");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().typeApplication());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"tyapId"), "150aTyapId");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.utilisateur());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"utlOrdre"), "160aUtlOrdre");
        dico.takeValueForKey((Object)UpdFactureRecette.chaineCtrlAction(ec, recette.recetteCtrlActions()), "170aChaineAction");
        dico.takeValueForKey((Object)UpdFactureRecette.chaineCtrlAnalytique(ec, recette.recetteCtrlAnalytiques()), "180aChaineAnalytique");
        dico.takeValueForKey((Object)UpdFactureRecette.chaineCtrlConvention(ec, recette.recetteCtrlConventions()), "190aChaineConvention");
        dico.takeValueForKey((Object)UpdFactureRecette.chaineCtrlPlanco(ec, recette.recetteCtrlPlancos()), "200aChainePlanco");
        dico.takeValueForKey((Object)UpdFactureRecette.chaineCtrlPlancoTva(ec, recette.recetteCtrlPlancos()), "210aChainePlancoTva");
        dico.takeValueForKey((Object)UpdFactureRecette.chaineCtrlPlancoCtp(ec, recette.recetteCtrlPlancos()), "220aChainePlancoCtp");
        dico.addEntriesFromDictionary(UpdFactureRecette.createRppAdrClientDictionnary(ec, recette));
        return dico;
    }

    private static NSDictionary createRppAdrClientDictionnary(EOEditingContext ec, EORecette recette) {
        EORecettePapierAdrClient currentAdresse;
        NSMutableDictionary dico = new NSMutableDictionary();
        NSDictionary dicoForPrimaryKeys = null;
        Object rppAdcIdAdrOrdre = null;
        Object rppAdcIdPersIdCreation = null;
        if (recette.recettePapier() != null && (currentAdresse = recette.recettePapier().currentRecPapierAdresseClient()) != null) {
            try {
                dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)currentAdresse.toAdresse());
                rppAdcIdAdrOrdre = dicoForPrimaryKeys.objectForKey((Object)"adrOrdre");
                dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)currentAdresse.toPersonneCreation());
                rppAdcIdPersIdCreation = dicoForPrimaryKeys.objectForKey((Object)"persId");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dico.takeValueForKey(rppAdcIdAdrOrdre, "230aRppAdcAdrOrdre");
        dico.takeValueForKey(rppAdcIdPersIdCreation, "240aRppAdcPersId");
        return dico;
    }

    protected static String chaineCtrlAction(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlAction recetteCtrlAction = (EORecetteCtrlAction)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlAction.lolfNomenclatureRecette());
            chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"lolfId") + "$";
            chaine = String.valueOf(chaine) + recetteCtrlAction.ractHtSaisie().setScale(2, 4) + "$";
            chaine = String.valueOf(chaine) + recetteCtrlAction.ractTtcSaisie().setScale(2, 4) + "$";
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlAnalytique(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlAnalytique recetteCtrlAnalytique = (EORecetteCtrlAnalytique)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlAnalytique.codeAnalytique());
            chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"canId") + "$";
            chaine = String.valueOf(chaine) + recetteCtrlAnalytique.ranaHtSaisie().setScale(2, 4) + "$";
            chaine = String.valueOf(chaine) + recetteCtrlAnalytique.ranaTtcSaisie().setScale(2, 4) + "$";
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlConvention(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlConvention recetteCtrlConvention = (EORecetteCtrlConvention)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlConvention.convention());
            chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"conOrdre") + "$";
            chaine = String.valueOf(chaine) + recetteCtrlConvention.rconHtSaisie().setScale(2, 4) + "$";
            chaine = String.valueOf(chaine) + recetteCtrlConvention.rconTtcSaisie().setScale(2, 4) + "$";
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlPlanco(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlPlanco recetteCtrlPlanco = (EORecetteCtrlPlanco)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlanco.planComptable());
            chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"pcoNum") + "$";
            chaine = String.valueOf(chaine) + recetteCtrlPlanco.rpcoHtSaisie().setScale(2, 4) + "$";
            chaine = String.valueOf(chaine) + recetteCtrlPlanco.rpcoTtcSaisie().setScale(2, 4) + "$";
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlPlancoTva(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlPlanco recetteCtrlPlanco = (EORecetteCtrlPlanco)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlanco.planComptable());
            String pcoNumPere = dicoForPrimaryKeys.objectForKey((Object)"pcoNum").toString();
            int j = 0;
            while (j < recetteCtrlPlanco.recetteCtrlPlancoTvas().count()) {
                EORecetteCtrlPlancoTva recetteCtrlPlancoTva = (EORecetteCtrlPlancoTva)((Object)recetteCtrlPlanco.recetteCtrlPlancoTvas().objectAtIndex(j));
                chaine = String.valueOf(chaine) + pcoNumPere + "$";
                dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlancoTva.planComptable());
                chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"pcoNum") + "$";
                chaine = String.valueOf(chaine) + recetteCtrlPlancoTva.rpcotvaTvaSaisie().setScale(2, 4) + "$";
                if (recetteCtrlPlancoTva.gestion() != null) {
                    dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlancoTva.gestion());
                    chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"gesCode") + "$";
                } else {
                    chaine = String.valueOf(chaine) + "$";
                }
                ++j;
            }
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlPlancoCtp(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlPlanco recetteCtrlPlanco = (EORecetteCtrlPlanco)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlanco.planComptable());
            String pcoNumPere = dicoForPrimaryKeys.objectForKey((Object)"pcoNum").toString();
            int j = 0;
            while (j < recetteCtrlPlanco.recetteCtrlPlancoCtps().count()) {
                EORecetteCtrlPlancoCtp recetteCtrlPlancoCtp = (EORecetteCtrlPlancoCtp)((Object)recetteCtrlPlanco.recetteCtrlPlancoCtps().objectAtIndex(j));
                chaine = String.valueOf(chaine) + pcoNumPere + "$";
                dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlancoCtp.planComptable());
                chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"pcoNum") + "$";
                chaine = String.valueOf(chaine) + recetteCtrlPlancoCtp.rpcoctpTtcSaisie().setScale(2, 4) + "$";
                if (recetteCtrlPlancoCtp.gestion() != null) {
                    dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlancoCtp.gestion());
                    chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"gesCode") + "$";
                } else {
                    chaine = String.valueOf(chaine) + "$";
                }
                ++j;
            }
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }
}

