/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.procedures;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import org.cocktail.kava.client.ServerProxy;
import org.cocktail.kava.client.metier.EORecette;
import org.cocktail.kava.client.metier.EORecetteCtrlAction;
import org.cocktail.kava.client.metier.EORecetteCtrlAnalytique;
import org.cocktail.kava.client.metier.EORecetteCtrlConvention;
import org.cocktail.kava.client.metier.EORecetteCtrlPlanco;
import org.cocktail.kava.client.metier.EORecetteCtrlPlancoCtp;
import org.cocktail.kava.client.metier.EORecetteCtrlPlancoTva;
import org.cocktail.kava.client.metier.EORecettePapierAdrClient;

public class InsFactureRecette {
    public static NSDictionary save(EOEditingContext ec, EORecette recette) throws Exception {
        if (recette == null) {
            throw new Exception("Facture-Recette a enregistrer null!!");
        }
        recette.validateObjectMetierWithFacture();
        NSDictionary dico = ServerProxy.apiInsFactureRecette(ec, InsFactureRecette.dico(ec, recette));
        return dico;
    }

    public static NSDictionary saveWithAddress(EOEditingContext ec, EORecette recette) throws Exception {
        if (recette == null) {
            throw new Exception("Facture-Recette-Adresse a enregistrer null!!");
        }
        recette.validateObjectMetierWithFacture();
        NSDictionary dico = ServerProxy.apiInsFactureRecetteAdresse(ec, InsFactureRecette.dico(ec, recette));
        return dico;
    }

    protected static NSDictionary dico(EOEditingContext ec, EORecette recette) throws Exception {
        NSMutableDictionary dico = new NSMutableDictionary();
        NSDictionary dicoForPrimaryKeys = null;
        dico.takeValueForKey(null, "010aFacId");
        dico.takeValueForKey(null, "020aRecId");
        if (recette.recettePapier() != null) {
            try {
                dicoForPrimaryKeys = ServerProxy.primaryKeyForGlobalID(ec, (EOEnterpriseObject)recette.recettePapier());
                dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"rppId"), "025aRppId");
            }
            catch (Exception e) {
                dico.takeValueForKey(null, "025aRppId");
            }
        } else {
            dico.takeValueForKey(null, "025aRppId");
        }
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.exercice());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"exeOrdre"), "030aExeOrdre");
        dico.takeValueForKey((Object)recette.facture().facNumero(), "040aFacNumero");
        dico.takeValueForKey((Object)recette.recNumero(), "050aRecNumero");
        if (recette.facture().fournisUlr() != null) {
            dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().fournisUlr());
            dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"fouOrdre"), "060aFouOrdre");
        } else {
            dico.takeValueForKey(null, "060aFouOrdre");
        }
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().personne());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"persId"), "070aPersId");
        dico.takeValueForKey((Object)recette.recLib(), "080aFacLib");
        if (recette.recettePapier() != null && recette.recettePapier().ribfourUlr() != null) {
            dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.recettePapier().ribfourUlr());
            dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"ribOrdre"), "085aRibOrdre");
        } else {
            dico.takeValueForKey(null, "085aRibOrdre");
        }
        if (recette.recettePapier() != null && recette.recettePapier().modeRecouvrement() != null) {
            dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.recettePapier().modeRecouvrement());
            dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"modOrdre"), "090aMorOrdre");
        } else {
            dico.takeValueForKey(null, "090aMorOrdre");
        }
        dico.takeValueForKey((Object)recette.recettePapier().rppNbPiece(), "095aRppNbPiece");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().organ());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"orgId"), "100aOrgId");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().typeCreditRec());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"tcdOrdre"), "110aTcdOrdre");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.tauxProrata());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"tapId"), "120aTapId");
        dico.takeValueForKey((Object)recette.recHtSaisie(), "130aFacHtSaisie");
        dico.takeValueForKey((Object)recette.recTtcSaisie(), "140aFacTtcSaisie");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.facture().typeApplication());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"tyapId"), "150aTyapId");
        dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recette.utilisateur());
        dico.takeValueForKey(dicoForPrimaryKeys.objectForKey((Object)"utlOrdre"), "160aUtlOrdre");
        dico.takeValueForKey((Object)InsFactureRecette.chaineCtrlAction(ec, recette.recetteCtrlActions()), "170aChaineAction");
        dico.takeValueForKey((Object)InsFactureRecette.chaineCtrlAnalytique(ec, recette.recetteCtrlAnalytiques()), "180aChaineAnalytique");
        dico.takeValueForKey((Object)InsFactureRecette.chaineCtrlConvention(ec, recette.recetteCtrlConventions()), "190aChaineConvention");
        dico.takeValueForKey((Object)InsFactureRecette.chaineCtrlPlanco(ec, recette.recetteCtrlPlancos()), "200aChainePlanco");
        dico.takeValueForKey((Object)InsFactureRecette.chaineCtrlPlancoTva(ec, recette.recetteCtrlPlancos()), "210aChainePlancoTva");
        dico.takeValueForKey((Object)InsFactureRecette.chaineCtrlPlancoCtp(ec, recette.recetteCtrlPlancos()), "220aChainePlancoCtp");
        dico.addEntriesFromDictionary(InsFactureRecette.createRppAdrClientDictionnary(ec, recette));
        return dico;
    }

    private static NSDictionary createRppAdrClientDictionnary(EOEditingContext ec, EORecette recette) {
        EORecettePapierAdrClient currentAdresse;
        NSMutableDictionary dico = new NSMutableDictionary();
        NSDictionary dicoForPrimaryKeys = null;
        Object rppAdcIdAdrOrdre = null;
        Object rppAdcIdPersIdCreation = null;
        if (recette.recettePapier() != null && (currentAdresse = recette.recettePapier().currentRecPapierAdresseClient()) != null) {
            try {
                dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)currentAdresse.toAdresse());
                rppAdcIdAdrOrdre = dicoForPrimaryKeys.objectForKey((Object)"adrOrdre");
                dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)currentAdresse.toPersonneCreation());
                rppAdcIdPersIdCreation = dicoForPrimaryKeys.objectForKey((Object)"persId");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dico.takeValueForKey(rppAdcIdAdrOrdre, "230aRppAdcAdrOrdre");
        dico.takeValueForKey(rppAdcIdPersIdCreation, "240aRppAdcPersId");
        return dico;
    }

    protected static String chaineCtrlAction(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlAction recetteCtrlAction = (EORecetteCtrlAction)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlAction.lolfNomenclatureRecette());
            chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"lolfId") + "$";
            chaine = String.valueOf(chaine) + recetteCtrlAction.ractHtSaisie().setScale(2, 4) + "$";
            chaine = String.valueOf(chaine) + recetteCtrlAction.ractTtcSaisie().setScale(2, 4) + "$";
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlAnalytique(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlAnalytique recetteCtrlAnalytique = (EORecetteCtrlAnalytique)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlAnalytique.codeAnalytique());
            chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"canId") + "$";
            chaine = String.valueOf(chaine) + recetteCtrlAnalytique.ranaHtSaisie().setScale(2, 4) + "$";
            chaine = String.valueOf(chaine) + recetteCtrlAnalytique.ranaTtcSaisie().setScale(2, 4) + "$";
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlConvention(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlConvention recetteCtrlConvention = (EORecetteCtrlConvention)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlConvention.convention());
            chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"conOrdre") + "$";
            chaine = String.valueOf(chaine) + recetteCtrlConvention.rconHtSaisie().setScale(2, 4) + "$";
            chaine = String.valueOf(chaine) + recetteCtrlConvention.rconTtcSaisie().setScale(2, 4) + "$";
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlPlanco(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlPlanco recetteCtrlPlanco = (EORecetteCtrlPlanco)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlanco.planComptable());
            chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"pcoNum") + "$";
            chaine = String.valueOf(chaine) + recetteCtrlPlanco.rpcoHtSaisie().setScale(2, 4) + "$";
            chaine = String.valueOf(chaine) + recetteCtrlPlanco.rpcoTtcSaisie().setScale(2, 4) + "$";
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlPlancoTva(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlPlanco recetteCtrlPlanco = (EORecetteCtrlPlanco)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlanco.planComptable());
            String pcoNumPere = dicoForPrimaryKeys.objectForKey((Object)"pcoNum").toString();
            int j = 0;
            while (j < recetteCtrlPlanco.recetteCtrlPlancoTvas().count()) {
                EORecetteCtrlPlancoTva recetteCtrlPlancoTva = (EORecetteCtrlPlancoTva)((Object)recetteCtrlPlanco.recetteCtrlPlancoTvas().objectAtIndex(j));
                chaine = String.valueOf(chaine) + pcoNumPere + "$";
                dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlancoTva.planComptable());
                chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"pcoNum") + "$";
                chaine = String.valueOf(chaine) + recetteCtrlPlancoTva.rpcotvaTvaSaisie().setScale(2, 4) + "$";
                if (recetteCtrlPlancoTva.gestion() != null) {
                    dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlancoTva.gestion());
                    chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"gesCode") + "$";
                } else {
                    chaine = String.valueOf(chaine) + "$";
                }
                ++j;
            }
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }

    protected static String chaineCtrlPlancoCtp(EOEditingContext ec, NSArray a) {
        if (a == null) {
            return "$";
        }
        String chaine = "";
        int i = 0;
        while (i < a.count()) {
            EORecetteCtrlPlanco recetteCtrlPlanco = (EORecetteCtrlPlanco)((Object)a.objectAtIndex(i));
            NSDictionary dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlanco.planComptable());
            String pcoNumPere = dicoForPrimaryKeys.objectForKey((Object)"pcoNum").toString();
            int j = 0;
            while (j < recetteCtrlPlanco.recetteCtrlPlancoCtps().count()) {
                EORecetteCtrlPlancoCtp recetteCtrlPlancoCtp = (EORecetteCtrlPlancoCtp)((Object)recetteCtrlPlanco.recetteCtrlPlancoCtps().objectAtIndex(j));
                chaine = String.valueOf(chaine) + pcoNumPere + "$";
                dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlancoCtp.planComptable());
                chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"pcoNum") + "$";
                chaine = String.valueOf(chaine) + recetteCtrlPlancoCtp.rpcoctpTtcSaisie().setScale(2, 4) + "$";
                if (recetteCtrlPlancoCtp.gestion() != null) {
                    dicoForPrimaryKeys = ServerProxy.primaryKeyForObject(ec, (EOEnterpriseObject)recetteCtrlPlancoCtp.gestion());
                    chaine = String.valueOf(chaine) + dicoForPrimaryKeys.objectForKey((Object)"gesCode") + "$";
                } else {
                    chaine = String.valueOf(chaine) + "$";
                }
                ++j;
            }
            ++i;
        }
        chaine = String.valueOf(chaine) + "$";
        return chaine;
    }
}

