/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.metier;

import com.webobjects.eoapplication.EOApplication;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSValidation;
import java.math.BigDecimal;
import java.util.Collections;
import org.cocktail.kava.client.factory.FactoryPrestationLigne;
import org.cocktail.kava.client.finder.FinderCatalogueArticle;
import org.cocktail.kava.client.finder.FinderTypeArticle;
import org.cocktail.kava.client.finder.FinderTypeEtat;
import org.cocktail.kava.client.metier.EOCatalogueArticle;
import org.cocktail.kava.client.metier._EOPrestationLigne;
import org.cocktail.pieFwk.common.ApplicationConfig;
import org.cocktail.pieFwk.common.metier.CatalogueArticle;
import org.cocktail.pieFwk.common.metier.Prestation;
import org.cocktail.pieFwk.common.metier.PrestationLigne;
import org.cocktail.pieFwk.common.metier.PrestationLigneCompanion;

public class EOPrestationLigne
extends _EOPrestationLigne
implements PrestationLigne {
    public static final String PRLIG_TOTAL_TVA_KEY = "prligTotalTva";
    public static final String PRLIG_TOTAL_RESTE_TVA_KEY = "prligTotalResteTva";
    private PrestationLigneCompanion companion = new PrestationLigneCompanion(this);

    public void setPrligArtHt(BigDecimal aValue) {
        super.setPrligArtHt(aValue);
        this.companion().updateTotalHt();
        this.companion().updateTotalResteHt();
    }

    public void setPrligArtTtc(BigDecimal aValue) {
        super.setPrligArtTtc(aValue);
        this.companion().updateTotalTtc();
        this.companion().updateTotalResteTtc();
    }

    public void setPrligQuantite(BigDecimal aValue) {
        super.setPrligQuantite(aValue);
        super.setPrligQuantiteReste(aValue);
        this.companion().updateTotaux();
        if (this.catalogueArticle() == null || this.catalogueArticle().article() == null || this.catalogueArticle().article().articles() == null || this.catalogueArticle().article().articles().count() == 0) {
            return;
        }
        this.updateOptionsRemises();
    }

    public void setPrligQuantiteReste(BigDecimal aValue) {
        super.setPrligQuantiteReste(aValue);
        this.companion().updateTotalResteHt();
        this.companion().updateTotalResteTtc();
        if (this.prestationLignes() != null) {
            int i = 0;
            while (i < this.prestationLignes().count()) {
                ((EOPrestationLigne)this.prestationLignes().objectAtIndex(i)).setPrligQuantiteReste(this.prligQuantiteReste());
                ++i;
            }
        }
    }

    private void updateOptionsRemises() {
        int i;
        if (this.catalogueArticle() == null) {
            return;
        }
        NSArray remises = FinderCatalogueArticle.find(this.editingContext(), this.catalogueArticle(), this.catalogueArticle().article().articlePrestation().typePublic(), FinderTypeEtat.typeEtatValide(this.editingContext()), Collections.singleton(FinderTypeArticle.typeArticleRemise(this.editingContext())), this.prligQuantite());
        if (this.prestationLignes() != null) {
            i = 0;
            while (this.prestationLignes().count() > i) {
                EOPrestationLigne pl = (EOPrestationLigne)this.prestationLignes().objectAtIndex(i);
                if (pl.catalogueArticle() != null && pl.catalogueArticle().article().typeArticle().equals((Object)FinderTypeArticle.typeArticleRemise(this.editingContext()))) {
                    if (remises != null && remises.containsObject((Object)pl.catalogueArticle())) {
                        pl.setPrligQuantite(this.prligQuantite());
                        ++i;
                        continue;
                    }
                    FactoryPrestationLigne.removeObject(this.editingContext(), pl, this);
                    this.editingContext().deleteObject((EOEnterpriseObject)pl);
                    continue;
                }
                pl.setPrligQuantite(this.prligQuantite());
                ++i;
            }
        }
        if (remises != null && remises.count() > 0) {
            i = 0;
            while (i < remises.count()) {
                EOCatalogueArticle catalogueArticle = (EOCatalogueArticle)remises.objectAtIndex(i);
                if (!((NSArray)this.prestationLignes().valueForKey("catalogueArticle")).containsObject((Object)catalogueArticle)) {
                    FactoryPrestationLigne.newObject(this.editingContext(), this, catalogueArticle);
                }
                ++i;
            }
        }
    }

    public BigDecimal prligTotalTva() {
        if (this.prligTotalTtc() == null) {
            return new BigDecimal(0.0);
        }
        if (this.prligTotalHt() == null) {
            return this.prligTotalTtc();
        }
        return this.prligTotalTtc().subtract(this.prligTotalHt());
    }

    public BigDecimal prligTotalResteTva() {
        if (this.prligTotalResteTtc() == null) {
            return new BigDecimal(0.0);
        }
        if (this.prligTotalResteHt() == null) {
            return this.prligTotalResteTtc();
        }
        return this.prligTotalResteTtc().subtract(this.prligTotalResteHt());
    }

    public void validateForInsert() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForInsert();
    }

    public void validateForUpdate() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForUpdate();
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        super.validateForDelete();
    }

    public void validateForSave() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForSave();
    }

    public void validateObjectMetier() throws NSValidation.ValidationException {
        if (this.typeArticle() == null) {
            throw new NSValidation.ValidationException("Il faut un type article pour les lignes du panier!");
        }
        if (this.prestation() == null) {
            throw new NSValidation.ValidationException("Il faut une prestation pour les lignes du panier!");
        }
        if (this.prligDate() == null) {
            throw new NSValidation.ValidationException("Il faut une date de creation pour les lignes du panier!");
        }
        if (this.prligDescription() == null) {
            throw new NSValidation.ValidationException("Il faut un libelle pour les lignes du panier!");
        }
        if (this.prligArtHt() == null) {
            throw new NSValidation.ValidationException("Il faut un prix HT pour les lignes du panier!");
        }
        if (this.prligArtTtc() == null) {
            throw new NSValidation.ValidationException("Il faut un prix TTC pour les lignes du panier!");
        }
        if (this.prligQuantite() == null) {
            throw new NSValidation.ValidationException("Il faut une quantite pour les lignes du panier!");
        }
        if (this.prligQuantiteReste() == null) {
            throw new NSValidation.ValidationException("Il faut une quantite restante pour les lignes du panier!");
        }
    }

    private final void validateBeforeTransactionSave() throws NSValidation.ValidationException {
    }

    public PrestationLigneCompanion companion() {
        return this.companion;
    }

    public Prestation getPrestationCommon() {
        return this.prestation();
    }

    public CatalogueArticle getCatalogueArticleCommon() {
        return this.catalogueArticle();
    }

    public ApplicationConfig applicationConfig() {
        return (ApplicationConfig)EOApplication.sharedApplication();
    }

    public Number exerciceAsNumber() {
        if (this.prestation() != null && this.prestation().exercice() != null) {
            return this.prestation().exercice().exeExercice();
        }
        return null;
    }
}

