/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.metier;

import com.webobjects.eoapplication.EOApplication;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSValidation;
import java.math.BigDecimal;
import org.cocktail.kava.client.ServerProxy;
import org.cocktail.kava.client.finder.FinderTauxProrata;
import org.cocktail.kava.client.finder.FinderTypeApplication;
import org.cocktail.kava.client.metier.EOPrestationAdrClient;
import org.cocktail.kava.client.metier.EOPrestationLigne;
import org.cocktail.kava.client.metier._EOPrestation;
import org.cocktail.pieFwk.common.ApplicationConfig;
import org.cocktail.pieFwk.common.metier.Prestation;
import org.cocktail.pieFwk.common.metier.PrestationCompanion;

public class EOPrestation
extends _EOPrestation
implements Prestation {
    public static final String PRIMARY_KEY_KEY = "prestId";
    private PrestationCompanion companion = new PrestationCompanion(this);

    public boolean updateTauxProrata() {
        boolean isDirty = false;
        if (this.tauxProrata() == null) {
            this.setTauxProrataRelationship(FinderTauxProrata.tauxProrata100(this.editingContext()));
            isDirty = true;
        }
        return isDirty;
    }

    public void setPrestRemiseGlobale(BigDecimal aValue) {
        super.setPrestRemiseGlobale(aValue);
        if (this.prestationLignes() != null) {
            int i = 0;
            while (i < this.prestationLignes().count()) {
                ((EOPrestationLigne)this.prestationLignes().objectAtIndex(i)).companion().updateTotaux();
                ++i;
            }
        }
    }

    public void setPrestApplyTva(String aValue) {
        super.setPrestApplyTva(aValue);
        if (this.prestationLignes() != null) {
            int i = 0;
            while (i < this.prestationLignes().count()) {
                EOPrestationLigne pl = (EOPrestationLigne)this.prestationLignes().objectAtIndex(i);
                if ("N".equalsIgnoreCase(this.prestApplyTva())) {
                    pl.setTvaRelationship(null);
                    pl.setPrligArtTtc(pl.prligArtHt());
                } else {
                    pl.setTvaRelationship(pl.tvaInitial());
                    pl.setPrligArtTtc(pl.prligArtTtcInitial());
                }
                ++i;
            }
        }
    }

    public boolean isValidableClient() {
        if (!this.typePublic().typeApplication().equals((Object)FinderTypeApplication.typeApplicationPrestationInterne(this.editingContext()))) {
            return true;
        }
        return this.prestationBudgetClient() != null && this.prestationBudgetClient().organ() != null && this.prestationBudgetClient().tauxProrata() != null && this.prestationBudgetClient().typeCreditDep() != null && this.prestationBudgetClient().lolfNomenclatureDepense() != null && this.prestationBudgetClient().pcoNum() != null;
    }

    public boolean isValidablePrest() {
        return this.organ() != null && this.tauxProrata() != null && this.typeCreditRec() != null && this.lolfNomenclatureRecette() != null;
    }

    public boolean isCloturable() {
        return true;
    }

    public boolean isFacturable() {
        return true;
    }

    public EOPrestationAdrClient currentPrestationAdresseClient() {
        EOPrestationAdrClient result = null;
        NSArray sortedAdr = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)this.toPrestationAdrClients(), (NSArray)new NSArray(new Object[]{EOPrestationAdrClient.SORT_DATE_CREATION_DESC}));
        if (sortedAdr != null && sortedAdr.count() > 0) {
            result = (EOPrestationAdrClient)((Object)sortedAdr.objectAtIndex(0));
        }
        return result;
    }

    public void validateForInsert() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForInsert();
    }

    public void validateForUpdate() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForUpdate();
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        super.validateForDelete();
    }

    public void validateForSave() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForSave();
    }

    public void validateObjectMetier() throws NSValidation.ValidationException {
        if (this.exercice() == null) {
            throw new NSValidation.ValidationException("Il faut un exercice pour la prestation!");
        }
        if (this.typePublic() == null) {
            throw new NSValidation.ValidationException("Il faut un type de client pour la prestation!");
        }
        if (this.typeEtat() == null) {
            throw new NSValidation.ValidationException("Il faut un etat pour la prestation!");
        }
        if (this.exercice() == null) {
            throw new NSValidation.ValidationException("Il faut un exercice pour la prestation!");
        }
        if (this.personne() == null) {
            throw new NSValidation.ValidationException("Il faut un client pour la prestation!");
        }
        if (this.utilisateur() == null) {
            throw new NSValidation.ValidationException("Il faut un agent (utilisateur) pour la prestation!");
        }
        if (this.prestationLignes() == null || this.prestationLignes().count() == 0) {
            throw new NSValidation.ValidationException("Il faut au moins une ligne dans le panier pour la prestation!");
        }
        if (this.prestDate() == null) {
            throw new NSValidation.ValidationException("Il faut une date de creation pour la prestation!");
        }
        if (this.prestLibelle() == null) {
            throw new NSValidation.ValidationException("Il faut un libelle pour la prestation!");
        }
        if (this.prestRemiseGlobale() != null && (this.prestRemiseGlobale().doubleValue() < 0.0 || this.prestRemiseGlobale().doubleValue() > 100.0)) {
            throw new NSValidation.ValidationException("Le pourcentage de remise globale doit etre entre 0 et 100 :-) !");
        }
    }

    private final void validateBeforeTransactionSave() throws NSValidation.ValidationException {
        if (this.prestNumero() == null) {
            try {
                this.setPrestNumero(ServerProxy.getNumerotation(this.editingContext(), this.exercice(), null, "PRESTATION").intValue());
            }
            catch (Exception e) {
                throw new NSValidation.ValidationException("Probleme pour numeroter la prestation : " + e);
            }
        }
        this.updateTauxProrata();
        this.companion().updateTotaux();
    }

    public BigDecimal remiseGlobale() {
        return this.prestRemiseGlobale();
    }

    public PrestationCompanion companion() {
        return this.companion;
    }

    public void setTotalHT(BigDecimal totalHT) {
        this.setPrestTotalHt(totalHT);
    }

    public void setTotalTVA(BigDecimal totalTVA) {
        this.setPrestTotalTva(totalTVA);
    }

    public void setTotalTTC(BigDecimal totalTTC) {
        this.setPrestTotalTtc(totalTTC);
    }

    public NSArray getPrestationLignesCommon() {
        return this.prestationLignes();
    }

    public ApplicationConfig applicationConfig() {
        return (ApplicationConfig)EOApplication.sharedApplication();
    }

    public Number exerciceAsNumber() {
        if (this.exercice() != null) {
            return this.exercice().exeExercice();
        }
        return null;
    }
}

