/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.metier;

import com.webobjects.eoapplication.EOApplication;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSValidation;
import java.math.BigDecimal;
import org.cocktail.kava.client.ServerProxy;
import org.cocktail.kava.client.finder.FinderPlanComptable;
import org.cocktail.kava.client.finder.FinderTauxProrata;
import org.cocktail.kava.client.finder.FinderTypeApplication;
import org.cocktail.kava.client.metier.EOFacturePapierAdrClient;
import org.cocktail.kava.client.metier.EOFacturePapierLigne;
import org.cocktail.kava.client.metier.EOPlanComptable;
import org.cocktail.kava.client.metier.EOTauxProrata;
import org.cocktail.kava.client.metier._EOFacturePapier;
import org.cocktail.pieFwk.common.ApplicationConfig;
import org.cocktail.pieFwk.common.metier.FacturePapier;
import org.cocktail.pieFwk.common.metier.FacturePapierCompanion;

public class EOFacturePapier
extends _EOFacturePapier
implements FacturePapier {
    private static final long serialVersionUID = 1L;
    public static final String FAP_TOTAL_HT_LIVE_KEY = "fapTotalHtLive";
    public static final String FAP_TOTAL_TTC_LIVE_KEY = "fapTotalTtcLive";
    public static final String FAP_TOTAL_TVA_LIVE_KEY = "fapTotalTvaLive";
    public static final String PRIMARY_KEY_KEY = "fapId";
    private EOPlanComptable planComptable;
    private EOPlanComptable planComptableCtp;
    private EOPlanComptable planComptableTva;
    private FacturePapierCompanion companion = new FacturePapierCompanion(this);

    public boolean updateTauxProrata() {
        boolean isDirty = false;
        if (this.tauxProrata() == null) {
            this.setTauxProrataRelationship(this.defaultTauxProrata());
            isDirty = true;
        }
        return isDirty;
    }

    private EOTauxProrata defaultTauxProrata() {
        return FinderTauxProrata.tauxProrata100(this.editingContext());
    }

    public EOPlanComptable planComptable() {
        if (this.planComptable == null) {
            this.planComptable = FinderPlanComptable.findById(this.editingContext(), this.exercice().exeOrdre(), this.pcoNum());
        }
        return this.planComptable;
    }

    public EOPlanComptable planComptableCtp() {
        if (this.planComptableCtp == null) {
            this.planComptableCtp = FinderPlanComptable.findById(this.editingContext(), this.exercice().exeOrdre(), this.pcoNumCtp());
        }
        return this.planComptableCtp;
    }

    public EOPlanComptable planComptableTva() {
        if (this.planComptableTva == null) {
            this.planComptableTva = FinderPlanComptable.findById(this.editingContext(), this.exercice().exeOrdre(), this.pcoNumTva());
        }
        return this.planComptableTva;
    }

    public void setPlanComptable(EOPlanComptable planComptable) {
        String pcoNum = planComptable == null ? null : planComptable.pcoNum();
        this.setPcoNum(pcoNum);
    }

    public void setPlanComptableCtp(EOPlanComptable planComptableCtp) {
        String pcoNumCtp = planComptableCtp == null ? null : planComptableCtp.pcoNum();
        this.setPcoNumCtp(pcoNumCtp);
    }

    public void setPlanComptableTva(EOPlanComptable planComptableTva) {
        String pcoNumTva = planComptableTva == null ? null : planComptableTva.pcoNum();
        this.setPcoNumTva(pcoNumTva);
    }

    public void setPcoNum(String value) {
        super.setPcoNum(value);
        this.planComptable = null;
    }

    public void setPcoNumCtp(String value) {
        super.setPcoNumCtp(value);
        this.planComptableCtp = null;
    }

    public void setPcoNumTva(String value) {
        super.setPcoNumTva(value);
        this.planComptableTva = null;
    }

    public EOFacturePapierAdrClient currentFactPapierAdresseClient() {
        EOFacturePapierAdrClient result = null;
        NSArray sortedAdr = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)this.toFacturePapierAdrClients(), (NSArray)new NSArray(new Object[]{EOFacturePapierAdrClient.SORT_DATE_CREATION_DESC}));
        if (sortedAdr != null && sortedAdr.count() > 0) {
            result = (EOFacturePapierAdrClient)((Object)sortedAdr.objectAtIndex(0));
        }
        return result;
    }

    public void setFapRemiseGlobale(BigDecimal aValue) {
        if (aValue != null && aValue.equals(this.fapRemiseGlobale())) {
            return;
        }
        super.setFapRemiseGlobale(aValue);
        if (this.facturePapierLignes() != null) {
            int i = 0;
            while (i < this.facturePapierLignes().count()) {
                ((EOFacturePapierLigne)this.facturePapierLignes().objectAtIndex(i)).companion().updateTotaux();
                ++i;
            }
        }
    }

    public void setFapApplyTva(String aValue) {
        if (aValue != null && aValue.equals(this.fapApplyTva())) {
            return;
        }
        super.setFapApplyTva(aValue);
        if (this.facturePapierLignes() != null) {
            int i = 0;
            while (i < this.facturePapierLignes().count()) {
                EOFacturePapierLigne flig = (EOFacturePapierLigne)this.facturePapierLignes().objectAtIndex(i);
                if ("N".equalsIgnoreCase(this.fapApplyTva())) {
                    flig.setTvaRelationship(null);
                    flig.setFligArtTtc(flig.fligArtHt());
                } else {
                    flig.setTvaRelationship(flig.tvaInitial());
                    flig.setFligArtTtc(flig.fligArtTtcInitial());
                }
                ++i;
            }
        }
    }

    public boolean isValidableClient() {
        if (!this.typePublic().typeApplication().equals((Object)FinderTypeApplication.typeApplicationPrestationInterne(this.editingContext()))) {
            return true;
        }
        return true;
    }

    public boolean isValidablePrest() {
        return this.organ() != null && this.typeCreditRec() != null && this.lolfNomenclatureRecette() != null && this.pcoNum() != null && this.modeRecouvrement() != null;
    }

    public void validateForInsert() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForInsert();
    }

    public void validateForUpdate() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForUpdate();
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        super.validateForDelete();
    }

    public void validateForSave() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForSave();
    }

    public void validateObjectMetier() throws NSValidation.ValidationException {
        if (this.exercice() == null) {
            throw new NSValidation.ValidationException("Il faut un exercice pour la facture papier!");
        }
        if (this.typePublic() == null) {
            throw new NSValidation.ValidationException("Il faut un type de client pour la facture papier!");
        }
        if (this.typeEtat() == null) {
            throw new NSValidation.ValidationException("Il faut un etat pour la facture papier!");
        }
        if (this.personne() == null) {
            throw new NSValidation.ValidationException("Il faut un client pour la facture papier!");
        }
        if (this.utilisateur() == null) {
            throw new NSValidation.ValidationException("Il faut un agent (utilisateur) pour la facture papier!");
        }
        if (this.facturePapierLignes() == null || this.facturePapierLignes().count() == 0) {
            throw new NSValidation.ValidationException("Il faut au moins une ligne dans le panier pour la facture papier!");
        }
        if (this.fapDate() == null) {
            throw new NSValidation.ValidationException("Il faut une date de creation pour la facture papier!");
        }
        if (this.fapLib() == null) {
            throw new NSValidation.ValidationException("Il faut un libelle pour la facture papier!");
        }
        if (this.fapRemiseGlobale() != null && (this.fapRemiseGlobale().doubleValue() < 0.0 || this.fapRemiseGlobale().doubleValue() > 100.0)) {
            throw new NSValidation.ValidationException("Le pourcentage de remise globale doit etre entre 0 et 100 :-) !");
        }
        if (this.ribfourUlr() == null && this.modeRecouvrement() != null && this.modeRecouvrement().isEcheancier()) {
            throw new NSValidation.ValidationException("Il faut un rib pour ce mode de recouvrement!");
        }
        if (!(this.echeId() == null || this.modeRecouvrement() != null && this.modeRecouvrement().isEcheancier())) {
            throw new NSValidation.ValidationException("Un echeancier existe pour cette facture, supprimer d'abord l'echeancier avant de changer de mode de recouvrement !");
        }
    }

    private final void validateBeforeTransactionSave() throws NSValidation.ValidationException {
        if (this.fapNumero() == null) {
            try {
                this.setFapNumero(Float.valueOf(ServerProxy.getNumerotation(this.editingContext(), this.exercice(), null, "FACTURE_PAPIER").intValue()));
            }
            catch (Exception e) {
                throw new NSValidation.ValidationException("Probleme pour numeroter la facture papier : " + e);
            }
        }
        this.updateTauxProrata();
        this.companion().updateTotaux();
    }

    public BigDecimal remiseGlobale() {
        return this.fapRemiseGlobale();
    }

    public FacturePapierCompanion companion() {
        return this.companion;
    }

    public void setTotalHT(BigDecimal totalHT) {
        this.setFapTotalHt(totalHT);
    }

    public void setTotalTVA(BigDecimal totalTVA) {
        this.setFapTotalTva(totalTVA);
    }

    public void setTotalTTC(BigDecimal totalTTC) {
        this.setFapTotalTtc(totalTTC);
    }

    public NSArray getFacturePapierLignesCommon() {
        return this.facturePapierLignes();
    }

    public ApplicationConfig applicationConfig() {
        return (ApplicationConfig)EOApplication.sharedApplication();
    }

    public Number exerciceAsNumber() {
        if (this.exercice() != null) {
            return this.exercice().exeExercice();
        }
        return null;
    }
}

