/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.metier;

import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSValidation;
import java.math.BigDecimal;
import org.cocktail.kava.client.metier._EOCatalogueArticle;
import org.cocktail.pieFwk.common.metier.CatalogueArticle;

public class EOCatalogueArticle
extends _EOCatalogueArticle
implements CatalogueArticle {
    private static final EOSortOrdering SORT_LIBELLE = EOSortOrdering.sortOrderingWithKey((String)"article.artLibelle", (NSSelector)EOSortOrdering.CompareAscending);

    public static NSArray sortedCatalogueArticlesByLibelle(NSArray catArticles) {
        return EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)catArticles, (NSArray)new NSArray((Object)SORT_LIBELLE));
    }

    public void validateForInsert() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForInsert();
    }

    public void validateForUpdate() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForUpdate();
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        super.validateForDelete();
    }

    public void validateForSave() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForSave();
    }

    public void validateObjectMetier() throws NSValidation.ValidationException {
        if (this.caarPrixHt() == null) {
            throw new NSValidation.ValidationException("Il faut un prix HT pour l'article!");
        }
        if (this.caarPrixTtc() == null) {
            throw new NSValidation.ValidationException("Il faut un prix TTC pour l'article!");
        }
        if (this.caarReference() == null) {
            throw new NSValidation.ValidationException("Il faut une reference pour l'article!");
        }
        if (this.catalogue() == null) {
            throw new NSValidation.ValidationException("Il faut un catalogue pour l'article!");
        }
        if (this.tva() == null) {
            throw new NSValidation.ValidationException("Il faut un taux de tva pour l'article!");
        }
        if (this.caarPrixHt().abs().compareTo(this.caarPrixTtc().abs()) == 1) {
            throw new NSValidation.ValidationException("Le prix HT ne peut etre superieur au prix TTC!");
        }
    }

    private final void validateBeforeTransactionSave() throws NSValidation.ValidationException {
    }

    public BigDecimal tauxTVA() {
        if (this.tva() == null) {
            return null;
        }
        return this.tva().tvaTaux();
    }
}

