/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.factory;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import org.cocktail.kava.client.factory.Factory;
import org.cocktail.kava.client.finder.FinderTauxProrata;
import org.cocktail.kava.client.finder.FinderTypeEtat;
import org.cocktail.kava.client.metier.EOFacture;
import org.cocktail.kava.client.metier.EORecette;
import org.cocktail.pieFwk.common.exception.EntityInitializationException;
import org.cocktail.pieFwk.common.exception.NoResultException;
import org.cocktail.pieFwk.common.exception.NonUniqueResultException;

public class FactoryRecette
extends Factory {
    public FactoryRecette() {
    }

    public FactoryRecette(boolean withLog) {
        super(withLog);
    }

    public static EORecette newObject(EOEditingContext ec) throws EntityInitializationException {
        try {
            EORecette recette = (EORecette)Factory.instanceForEntity(ec, "Recette");
            recette.setRecDateSaisie(Factory.getDateJour());
            recette.setTypeEtatRelationship(FinderTypeEtat.typeEtatValide(ec));
            recette.setTauxProrataRelationship(FinderTauxProrata.tauxProrata100(ec));
            ec.insertObject((EOEnterpriseObject)recette);
            return recette;
        }
        catch (NoResultException nre) {
            throw new EntityInitializationException(nre.getMessage());
        }
        catch (NonUniqueResultException nure) {
            throw new EntityInitializationException(nure.getMessage());
        }
    }

    public static EORecette newObject(EOEditingContext ec, EOFacture facture) throws EntityInitializationException {
        EORecette recette = FactoryRecette.newObject(ec);
        if (facture != null) {
            recette.setFactureRelationship(facture);
            recette.setExerciceRelationship(facture.exercice());
            recette.setTauxProrataRelationship(facture.tauxProrata());
        }
        return recette;
    }
}

