/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.service;

import com.webobjects.eocontrol.EOEditingContext;
import java.math.BigDecimal;
import org.cocktail.pieFwk.common.ApplicationConfig;
import org.cocktail.pieFwk.common.metier.MockFacturePapier;
import org.cocktail.pieFwk.common.metier.MockFacturePapierLigne;
import org.cocktail.pieFwk.common.service.FacturePapierLigneService;
import org.junit.Assert;
import org.junit.Test;

public class FacturePapierLigneServiceTest {
    private FacturePapierLigneService ligneService = FacturePapierLigneService.instance();

    @Test
    public void testEstDivisible() {
        Assert.assertFalse((boolean)this.ligneService.estDivisible(null));
        Assert.assertFalse((boolean)this.ligneService.estDivisible(BigDecimal.ZERO));
        Assert.assertTrue((boolean)this.ligneService.estDivisible(BigDecimal.TEN));
    }

    @Test
    public void testIsCalculPossible() {
        Assert.assertFalse((boolean)this.ligneService.isCalculPossible(null, null, null));
        Assert.assertFalse((boolean)this.ligneService.isCalculPossible(BigDecimal.TEN, null, null));
        Assert.assertFalse((boolean)this.ligneService.isCalculPossible(null, BigDecimal.TEN, null));
        Assert.assertFalse((boolean)this.ligneService.isCalculPossible(null, null, BigDecimal.TEN));
        Assert.assertFalse((boolean)this.ligneService.isCalculPossible(BigDecimal.TEN, BigDecimal.TEN, null));
        Assert.assertFalse((boolean)this.ligneService.isCalculPossible(BigDecimal.TEN, null, BigDecimal.TEN));
        Assert.assertFalse((boolean)this.ligneService.isCalculPossible(null, BigDecimal.TEN, BigDecimal.TEN));
        Assert.assertTrue((boolean)this.ligneService.isCalculPossible(BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN));
    }

    @Test
    public void testCalculerTauxTva() {
        Assert.assertEquals((Object)BigDecimal.valueOf(1.196), (Object)this.ligneService.calculerTauxTva(BigDecimal.valueOf(100.0), BigDecimal.valueOf(119.6), 3, BigDecimal.ONE));
        Assert.assertEquals((Object)BigDecimal.valueOf(1.2).setScale(2), (Object)this.ligneService.calculerTauxTva(BigDecimal.valueOf(100.0), BigDecimal.valueOf(119.6), 2, BigDecimal.ONE));
        Assert.assertEquals((Object)BigDecimal.valueOf(1.058), (Object)this.ligneService.calculerTauxTva(BigDecimal.valueOf(52.0), BigDecimal.valueOf(55.0), 3, BigDecimal.ONE));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)this.ligneService.calculerTauxTva(BigDecimal.ZERO, BigDecimal.valueOf(55.0), 3, BigDecimal.ONE));
        Assert.assertEquals((Object)BigDecimal.valueOf(1.196), (Object)this.ligneService.calculerTauxTva(BigDecimal.valueOf(19.6), 3));
    }

    @Test
    public void testCalculerMontantTotalHTExact() {
        BigDecimal TOTAL_HT = BigDecimal.valueOf(30.0).setScale(2);
        Assert.assertEquals((Object)TOTAL_HT, (Object)this.ligneService.calculerMontantTotalHTExact(BigDecimal.valueOf(10.0), BigDecimal.valueOf(3.0)));
    }

    @Test
    public void testIsCalculTotalTTCAvecTVACommeBaseCalcul() {
        Assert.assertFalse((boolean)this.ligneService.isCalculTotalTTCAvecTVACommeBaseCalcul(BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN));
        Assert.assertFalse((boolean)this.ligneService.isCalculTotalTTCAvecTVACommeBaseCalcul(BigDecimal.TEN, BigDecimal.ZERO, BigDecimal.TEN));
        Assert.assertFalse((boolean)this.ligneService.isCalculTotalTTCAvecTVACommeBaseCalcul(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.TEN));
        Assert.assertTrue((boolean)this.ligneService.isCalculTotalTTCAvecTVACommeBaseCalcul(BigDecimal.ZERO, BigDecimal.TEN, BigDecimal.TEN));
    }

    @Test
    public void testCalculerMontantTotalTTCRemiseIncluseAvecDecimales() {
        MockFacturePapier facturePapierSansRemise = new MockFacturePapier(){

            public BigDecimal remiseGlobale() {
                return BigDecimal.ZERO;
            }
        };
        BigDecimal MT_HT = BigDecimal.valueOf(100.0).setScale(2, 4);
        BigDecimal MT_TTC = BigDecimal.valueOf(119.6).setScale(2, 4);
        BigDecimal QUANTITE = BigDecimal.valueOf(1.0);
        MockFacturePapierLigne ligne = new MockFacturePapierLigne(facturePapierSansRemise);
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 2;
            }
        });
        ligne.setFligArtHt(MT_HT);
        ligne.setFligArtTtc(MT_TTC);
        ligne.setFligQuantite(QUANTITE);
        BigDecimal expected = BigDecimal.valueOf(119.6).setScale(2, 4);
        Assert.assertEquals((Object)expected, (Object)this.ligneService.calculerMontantTotalTTCRemiseIncluse(ligne));
    }

    @Test
    public void testCalculerMontantTotalTTCRemiseIncluseSansDecimales() {
        MockFacturePapier facturePapierSansRemise = new MockFacturePapier(){

            public BigDecimal remiseGlobale() {
                return BigDecimal.ZERO;
            }
        };
        BigDecimal MT_HT = BigDecimal.valueOf(100.0).setScale(0, 4);
        BigDecimal MT_TTC = BigDecimal.valueOf(119.6).setScale(0, 4);
        BigDecimal QUANTITE = BigDecimal.valueOf(1.0);
        MockFacturePapierLigne ligne = new MockFacturePapierLigne(facturePapierSansRemise);
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        ligne.setFligArtHt(MT_HT);
        ligne.setFligArtTtc(MT_TTC);
        ligne.setFligQuantite(QUANTITE);
        BigDecimal expected = BigDecimal.valueOf(120.0).setScale(0, 4);
        Assert.assertEquals((Object)expected, (Object)this.ligneService.calculerMontantTotalTTCRemiseIncluse(ligne));
    }

    @Test
    public void testCalculerMontantTotalTTCRemiseIncluseNouvelleCaledonie() {
        MockFacturePapier facturePapierSansRemise = new MockFacturePapier(){

            public BigDecimal remiseGlobale() {
                return BigDecimal.ZERO;
            }
        };
        BigDecimal MT_HT = BigDecimal.valueOf(774.0).setScale(0, 4);
        BigDecimal MT_TTC = BigDecimal.valueOf(813.0).setScale(0, 4);
        BigDecimal QUANTITE = BigDecimal.valueOf(4.0);
        MockFacturePapierLigne ligne = new MockFacturePapierLigne(facturePapierSansRemise);
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        ligne.setFligArtHt(MT_HT);
        ligne.setFligArtTtc(MT_TTC);
        ligne.setFligQuantite(QUANTITE);
        BigDecimal expected = BigDecimal.valueOf(3251.0).setScale(0, 4);
        Assert.assertEquals((Object)expected, (Object)this.ligneService.calculerMontantTotalTTCRemiseIncluse(ligne));
    }

    @Test
    public void testCalculerMontantTotalTTCRemiseIncluseAvecTVASeulement() {
        MockFacturePapier facturePapierSansRemise = new MockFacturePapier(){

            public BigDecimal remiseGlobale() {
                return BigDecimal.ZERO;
            }
        };
        BigDecimal MT_HT = BigDecimal.ZERO.setScale(2, 4);
        BigDecimal MT_TTC = BigDecimal.valueOf(1500.43).setScale(2, 4);
        BigDecimal QUANTITE = BigDecimal.valueOf(4.0);
        MockFacturePapierLigne ligne = new MockFacturePapierLigne(facturePapierSansRemise);
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 2;
            }
        });
        ligne.setFligArtHt(MT_HT);
        ligne.setFligArtTtc(MT_TTC);
        ligne.setFligQuantite(QUANTITE);
        BigDecimal expected = BigDecimal.valueOf(6001.72).setScale(2, 4);
        Assert.assertEquals((Object)expected, (Object)this.ligneService.calculerMontantTotalTTCRemiseIncluse(ligne));
    }
}

