/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.metier;

import java.math.BigDecimal;
import org.cocktail.pieFwk.common.metier.PrestationLigne;
import org.cocktail.pieFwk.common.service.PrestationLigneService;

public class PrestationLigneCompanion {
    private PrestationLigne ligne;
    private PrestationLigneService ligneService;

    public PrestationLigneCompanion(PrestationLigne ligne) {
        this.ligne = ligne;
        this.ligneService = PrestationLigneService.instance();
    }

    public PrestationLigneService service() {
        return this.ligneService;
    }

    public void updateTotaux() {
        this.updateTotalHt();
        this.updateTotalTtc();
        this.updateTotalResteHt();
        this.updateTotalResteTtc();
    }

    public void updateTotalHt() {
        BigDecimal articleHT = this.ligne().prligArtHt();
        BigDecimal quantite = this.ligne().prligQuantite();
        BigDecimal totalHTRemiseIncluse = null;
        if (this.isCalculPossible(articleHT, quantite)) {
            totalHTRemiseIncluse = this.service().calculerMontantTotalHTRemiseIncluse(this.ligne());
        }
        this.ligne().setPrligTotalHt(totalHTRemiseIncluse);
    }

    public void updateTotalResteHt() {
        BigDecimal articleHT = this.ligne().prligArtHt();
        BigDecimal quantiteReste = this.ligne().prligQuantiteReste();
        BigDecimal totalResteHTRemiseIncluse = null;
        if (this.isCalculPossible(articleHT, quantiteReste)) {
            int nbDecimales = this.ligne().applicationConfig().nbDecimalesImposees(this.ligne().editingContext(), this.ligne().exerciceAsNumber());
            totalResteHTRemiseIncluse = this.service().applyRemise(articleHT.multiply(quantiteReste), this.service().getRemiseGlobale(this.ligne())).setScale(nbDecimales, 4);
        }
        this.ligne().setPrligTotalResteHt(totalResteHTRemiseIncluse);
    }

    public void updateTotalTtc() {
        BigDecimal articleHT = this.ligne().prligArtHt();
        BigDecimal articleTTC = this.ligne().prligArtTtc();
        BigDecimal quantite = this.ligne().prligQuantite();
        BigDecimal totalTTCRemiseIncluse = null;
        if (this.isCalculPossible(articleTTC, quantite)) {
            totalTTCRemiseIncluse = this.service().calculerMontantTotalTTCRemiseIncluse(this.ligne(), articleHT, articleTTC, quantite);
        }
        this.ligne().setPrligTotalTtc(totalTTCRemiseIncluse);
    }

    public void updateTotalResteTtc() {
        BigDecimal articleHT = this.ligne().prligArtHt();
        BigDecimal articleTTC = this.ligne().prligArtTtc();
        BigDecimal quantiteReste = this.ligne().prligQuantiteReste();
        BigDecimal totalResteTTCRemiseIncluse = null;
        if (this.isCalculPossible(articleTTC, quantiteReste)) {
            totalResteTTCRemiseIncluse = this.service().calculerMontantTotalTTCRemiseIncluse(this.ligne(), articleHT, articleTTC, quantiteReste);
        }
        this.ligne().setPrligTotalResteTtc(totalResteTTCRemiseIncluse);
    }

    public BigDecimal tauxTvaCatalogueArticle() {
        if (this.ligne() != null && this.ligne().getCatalogueArticleCommon() != null) {
            return this.ligne().getCatalogueArticleCommon().tauxTVA();
        }
        return null;
    }

    protected boolean isCalculPossible(BigDecimal montant, BigDecimal quantite) {
        return montant != null && quantite != null;
    }

    public PrestationLigne ligne() {
        return this.ligne;
    }
}

