/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.metier;

import com.webobjects.eocontrol.EOEditingContext;
import java.math.BigDecimal;
import org.cocktail.pieFwk.common.ApplicationConfig;
import org.cocktail.pieFwk.common.metier.FacturePapierLigne;
import org.cocktail.pieFwk.common.metier.FacturePapierLigneCompanion;
import org.cocktail.pieFwk.common.metier.MockFacturePapierLigne;
import org.junit.Assert;
import org.junit.Test;

public class FacturePapierLigneCompanionTest {
    @Test
    public void testIsCalculPossible() {
        MockFacturePapierLigne ligne = new MockFacturePapierLigne();
        FacturePapierLigneCompanion companion = new FacturePapierLigneCompanion(ligne);
        Assert.assertFalse((boolean)companion.isCalculPossible(null, null));
        Assert.assertFalse((boolean)companion.isCalculPossible(BigDecimal.TEN, null));
        Assert.assertFalse((boolean)companion.isCalculPossible(null, BigDecimal.TEN));
        Assert.assertTrue((boolean)companion.isCalculPossible(BigDecimal.TEN, BigDecimal.ONE));
    }

    @Test
    public void testUpdateTotalHtEchec() {
        MockFacturePapierLigne ligne = new MockFacturePapierLigne();
        FacturePapierLigneCompanion companion = new FacturePapierLigneCompanion(ligne){

            protected boolean isCalculPossible(BigDecimal montant, BigDecimal quantite) {
                return false;
            }
        };
        companion.updateTotalHt();
        Assert.assertNull((Object)ligne.fligTotalHt());
    }

    @Test
    public void testUpdateTotalHtSucces() {
        MockFacturePapierLigne ligne = new MockFacturePapierLigne();
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        FacturePapierLigneCompanion companion = new FacturePapierLigneCompanion(ligne);
        ligne.setFligArtHt(BigDecimal.ZERO);
        ligne.setFligQuantite(BigDecimal.valueOf(2.0));
        companion.updateTotalHt();
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)ligne.fligTotalHt());
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 2;
            }
        });
        ligne.setFligArtHt(BigDecimal.valueOf(100.33));
        ligne.setFligQuantite(BigDecimal.valueOf(2.0));
        companion.updateTotalHt();
        Assert.assertEquals((Object)BigDecimal.valueOf(200.66).setScale(2), (Object)ligne.fligTotalHt());
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        ligne.setFligArtHt(BigDecimal.valueOf(100.0).setScale(0));
        ligne.setFligQuantite(BigDecimal.valueOf(2.0));
        companion.updateTotalHt();
        Assert.assertEquals((Object)BigDecimal.valueOf(200.0).setScale(0), (Object)ligne.fligTotalHt());
    }

    @Test
    public void testUpdateTotalTtc() {
        MockFacturePapierLigne ligne = new MockFacturePapierLigne();
        FacturePapierLigneCompanion companion = new FacturePapierLigneCompanion(ligne);
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        ligne.setFligArtTtc(null);
        ligne.setFligQuantite(null);
        companion.updateTotalTtc();
        Assert.assertNull((Object)ligne.fligTotalTtc());
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        ligne.setFligArtHt(null);
        ligne.setFligArtTtc(BigDecimal.TEN);
        ligne.setFligQuantite(BigDecimal.valueOf(2.0));
        companion.updateTotalTtc();
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)ligne.fligTotalTtc());
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 2;
            }
        });
        ligne.setFligArtHt(BigDecimal.ZERO.setScale(2));
        ligne.setFligArtTtc(BigDecimal.valueOf(4.25));
        ligne.setFligQuantite(BigDecimal.valueOf(3.0));
        companion.updateTotalTtc();
        Assert.assertEquals((Object)BigDecimal.valueOf(12.75).setScale(2), (Object)ligne.fligTotalTtc());
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 2;
            }
        });
        ligne.setFligArtHt(BigDecimal.valueOf(100.0));
        ligne.setFligArtTtc(BigDecimal.valueOf(119.6));
        ligne.setFligQuantite(BigDecimal.valueOf(2.0));
        companion.updateTotalTtc();
        Assert.assertEquals((Object)BigDecimal.valueOf(239.2).setScale(2), (Object)ligne.fligTotalTtc());
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        ligne.setFligArtHt(BigDecimal.valueOf(100.0).setScale(0));
        ligne.setFligArtTtc(BigDecimal.valueOf(119.6));
        ligne.setFligQuantite(BigDecimal.valueOf(2.0));
        companion.updateTotalTtc();
        Assert.assertEquals((Object)BigDecimal.valueOf(239.0).setScale(0), (Object)ligne.fligTotalTtc());
    }

    @Test
    public void testModifierQuantiteAvecVerificationSetter() {
        MockFacturePapierLigne ligneQteSeule = new MockFacturePapierLigne();
        FacturePapierLigneCompanion companionQteSeule = new FacturePapierLigneCompanion(ligneQteSeule);
        companionQteSeule.modifierQuantite(BigDecimal.TEN);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)ligneQteSeule.fligQuantite());
        Assert.assertNull((Object)ligneQteSeule.fligTotalHt());
        Assert.assertNull((Object)ligneQteSeule.fligTotalTtc());
    }

    @Test
    public void testModifierQuantiteAvecEnfantsAvecVerificationSetter() {
        MockFacturePapierLigne ligneQteSeule = new MockFacturePapierLigne();
        ligneQteSeule.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        ligneQteSeule.addToFacturePapierLignesRelationship(new MockFacturePapierLigne());
        ligneQteSeule.setFligQuantite(BigDecimal.ZERO);
        ligneQteSeule.companion().modifierQuantite(BigDecimal.TEN);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)ligneQteSeule.fligQuantite());
        Assert.assertNull((Object)ligneQteSeule.fligTotalHt());
        Assert.assertNull((Object)ligneQteSeule.fligTotalTtc());
        FacturePapierLigne enfantQteSeule = (FacturePapierLigne)ligneQteSeule.facturePapierLignes().objectAtIndex(0);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)enfantQteSeule.fligQuantite());
        Assert.assertNull((Object)enfantQteSeule.fligTotalHt());
        Assert.assertNull((Object)enfantQteSeule.fligTotalTtc());
        MockFacturePapierLigne ligneQteEtHT = new MockFacturePapierLigne();
        ligneQteEtHT.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 2;
            }
        });
        ligneQteEtHT.addToFacturePapierLignesRelationship(new MockFacturePapierLigne());
        ligneQteEtHT.setFligQuantite(BigDecimal.TEN);
        ligneQteEtHT.setFligArtHt(BigDecimal.valueOf(2.0));
        ligneQteEtHT.companion().modifierQuantite(BigDecimal.TEN);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)ligneQteEtHT.fligQuantite());
        BigDecimal totalHTExpected = BigDecimal.valueOf(20.0).setScale(2);
        Assert.assertEquals((Object)totalHTExpected, (Object)ligneQteEtHT.fligTotalHt());
        Assert.assertNull((Object)ligneQteEtHT.fligTotalTtc());
        FacturePapierLigne enfantQteEtHT = (FacturePapierLigne)ligneQteEtHT.facturePapierLignes().objectAtIndex(0);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)enfantQteEtHT.fligQuantite());
        Assert.assertNull((Object)enfantQteEtHT.fligTotalHt());
        Assert.assertNull((Object)enfantQteEtHT.fligTotalTtc());
    }

    @Test
    public void testModifierQuantiteAvec2DecimalesEtVerificationMiseAJourTotaux() {
        BigDecimal MT_UNITAIRE_HT = BigDecimal.valueOf(774.0).setScale(2);
        BigDecimal MT_UNITAIRE_TTC = BigDecimal.valueOf(813.0).setScale(2);
        BigDecimal QUANTITE = BigDecimal.valueOf(25.0);
        BigDecimal TOTAL_HT = BigDecimal.valueOf(19350.0).setScale(2);
        BigDecimal TOTAL_TTC = BigDecimal.valueOf(20317.5).setScale(2);
        MockFacturePapierLigne ligne = new MockFacturePapierLigne();
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 2;
            }
        });
        ligne.setFligArtHt(MT_UNITAIRE_HT);
        ligne.setFligArtTtc(MT_UNITAIRE_TTC);
        ligne.companion().modifierQuantite(QUANTITE);
        Assert.assertEquals((Object)MT_UNITAIRE_HT, (Object)ligne.fligArtHt());
        Assert.assertEquals((Object)MT_UNITAIRE_TTC, (Object)ligne.fligArtTtc());
        Assert.assertEquals((Object)TOTAL_HT, (Object)ligne.fligTotalHt());
        Assert.assertEquals((Object)TOTAL_TTC, (Object)ligne.fligTotalTtc());
    }

    @Test
    public void testModifierQuantiteSansDecimaleEtVerificationMiseAJourTotaux() {
        BigDecimal MT_UNITAIRE_HT = BigDecimal.valueOf(774.0).setScale(0);
        BigDecimal MT_UNITAIRE_TTC = BigDecimal.valueOf(813.0).setScale(0);
        BigDecimal QUANTITE = BigDecimal.valueOf(25.0);
        BigDecimal TOTAL_HT = BigDecimal.valueOf(19350.0).setScale(0);
        BigDecimal TOTAL_TTC = BigDecimal.valueOf(20318.0).setScale(0);
        MockFacturePapierLigne ligne = new MockFacturePapierLigne();
        ligne.setApplicationConfig(new ApplicationConfig(){

            public int nbDecimalesImposees(EOEditingContext edc, Number exercice) {
                return 0;
            }
        });
        ligne.setFligArtHt(MT_UNITAIRE_HT);
        ligne.setFligArtTtc(MT_UNITAIRE_TTC);
        ligne.companion().modifierQuantite(QUANTITE);
        Assert.assertEquals((Object)MT_UNITAIRE_HT, (Object)ligne.fligArtHt());
        Assert.assertEquals((Object)MT_UNITAIRE_TTC, (Object)ligne.fligArtTtc());
        Assert.assertEquals((Object)TOTAL_HT, (Object)ligne.fligTotalHt());
        Assert.assertEquals((Object)TOTAL_TTC, (Object)ligne.fligTotalTtc());
    }
}

