/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.metier;

import com.webobjects.foundation.NSArray;
import java.math.BigDecimal;
import org.cocktail.pieFwk.common.metier.FacturePapierLigne;
import org.cocktail.pieFwk.common.service.FacturePapierLigneService;

public class FacturePapierLigneCompanion {
    private FacturePapierLigneService ligneService;
    private FacturePapierLigne ligne;

    public FacturePapierLigneCompanion(FacturePapierLigne ligne) {
        this.ligne = ligne;
        this.ligneService = FacturePapierLigneService.instance();
    }

    public void modifierQuantite(BigDecimal quantite) {
        this.ligne().setFligQuantite(quantite);
        this.updateTotaux();
        this.modifierQuantiteEnfants(quantite);
    }

    protected void modifierQuantiteEnfants(BigDecimal quantite) {
        NSArray lignesEnfants = this.ligne().facturePapierLignes();
        if (lignesEnfants != null) {
            int i = 0;
            while (i < lignesEnfants.count()) {
                ((FacturePapierLigne)lignesEnfants.objectAtIndex(i)).companion().modifierQuantite(quantite);
                ++i;
            }
        }
    }

    public void updateTotaux() {
        this.updateTotalHt();
        this.updateTotalTtc();
    }

    public void updateTotalHt() {
        BigDecimal articleHT = this.ligne().fligArtHt();
        BigDecimal quantite = this.ligne().fligQuantite();
        BigDecimal totalHTRemiseIncluse = null;
        if (this.isCalculPossible(articleHT, quantite)) {
            totalHTRemiseIncluse = this.getLigneService().calculerMontantTotalHTRemiseIncluse(this.ligne());
        }
        this.ligne().setFligTotalHt(totalHTRemiseIncluse);
    }

    public void updateTotalTtc() {
        BigDecimal articleTTC = this.ligne().fligArtTtc();
        BigDecimal quantite = this.ligne().fligQuantite();
        BigDecimal totalTTCRemiseIncluse = null;
        if (this.isCalculPossible(articleTTC, quantite)) {
            totalTTCRemiseIncluse = this.getLigneService().calculerMontantTotalTTCRemiseIncluse(this.ligne());
        }
        this.ligne().setFligTotalTtc(totalTTCRemiseIncluse);
    }

    protected boolean isCalculPossible(BigDecimal montant, BigDecimal quantite) {
        return montant != null && quantite != null;
    }

    public FacturePapierLigne ligne() {
        return this.ligne;
    }

    public FacturePapierLigneService getLigneService() {
        return this.ligneService;
    }

    public void setLigneService(FacturePapierLigneService ligneService) {
        this.ligneService = ligneService;
    }
}

