/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.pieFwk.common.metier;

import com.webobjects.foundation.NSArray;
import java.math.BigDecimal;
import org.cocktail.pieFwk.common.metier.FacturePapier;
import org.cocktail.pieFwk.common.metier.FacturePapierLigne;
import org.cocktail.pieFwk.common.service.FacturePapierLigneService;

public class FacturePapierCompanion {
    private FacturePapier facturePapier;
    private FacturePapierLigneService ligneService;

    public FacturePapierCompanion(FacturePapier facturePapier) {
        this.facturePapier = facturePapier;
        this.ligneService = FacturePapierLigneService.instance();
    }

    public BigDecimal totalHTLive() {
        if (this.facturePapierLignes() == null || this.facturePapierLignes().count() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalLive = BigDecimal.ZERO;
        int idx = 0;
        while (idx < this.facturePapierLignes().count()) {
            FacturePapierLigne ligne = (FacturePapierLigne)this.facturePapierLignes().objectAtIndex(idx);
            BigDecimal ligneTotalHT = this.ligneService().calculerMontantTotalHTExact(ligne.fligArtHt(), ligne.fligQuantite());
            totalLive = totalLive.add(ligneTotalHT);
            ++idx;
        }
        return this.ligneService().applyRemise(totalLive, this.facturePapier().remiseGlobale(), this.ligneService().determineNombreDecimalesImposees(this.facturePapier()));
    }

    public BigDecimal totalTTCLive() {
        if (this.facturePapierLignes() == null || this.facturePapierLignes().count() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalLive = BigDecimal.ZERO;
        int idx = 0;
        while (idx < this.facturePapierLignes().count()) {
            FacturePapierLigne ligne = (FacturePapierLigne)this.facturePapierLignes().objectAtIndex(idx);
            BigDecimal ligneTotalTTC = this.ligneService().calculerMontantTotalTTCExact(ligne.fligArtHt(), ligne.fligArtTtc(), ligne.fligQuantite(), this.ligneService().getTauxTva(ligne));
            totalLive = totalLive.add(ligneTotalTTC);
            ++idx;
        }
        return this.ligneService().applyRemise(totalLive, this.facturePapier().remiseGlobale(), this.ligneService().determineNombreDecimalesImposees(this.facturePapier()));
    }

    public BigDecimal totalTVALive() {
        return this.totalTTCLive().subtract(this.totalHTLive());
    }

    public void updateTotaux() {
        BigDecimal totalHTLive = this.totalHTLive();
        BigDecimal totalTTCLive = this.totalTTCLive();
        BigDecimal totalTVALive = totalTTCLive.subtract(totalHTLive).setScale(totalHTLive.scale());
        this.facturePapier().setTotalHT(totalHTLive);
        this.facturePapier().setTotalTVA(totalTVALive);
        this.facturePapier().setTotalTTC(totalTTCLive);
    }

    public FacturePapier facturePapier() {
        return this.facturePapier;
    }

    public NSArray facturePapierLignes() {
        if (this.facturePapier() == null) {
            return new NSArray();
        }
        return this.facturePapier().getFacturePapierLignesCommon();
    }

    public FacturePapierLigneService ligneService() {
        return this.ligneService;
    }
}

