/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.selector;

import java.util.ArrayList;
import java.util.List;
import org.cocktail.kava.client.metier.EOFournisUlr;
import org.cocktail.kava.client.selector.FournisseurEtatControle;
import org.cocktail.kava.client.selector.FournisseurFiltre;
import org.cocktail.pieFwk.selector.IFiltre;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FournisseurFiltreTest {
    @Test
    public void testFiltrerFournisseursValidesNull() {
        FournisseurFiltre listeFiltreFournisseurValide = new FournisseurFiltre();
        FournisseurEtatControle filtreFournisseurValide = new FournisseurEtatControle("O");
        List fournisseursValides = listeFiltreFournisseurValide.filtrer(null, (IFiltre<K>[])new IFiltre[]{filtreFournisseurValide});
        Assert.assertNotNull(fournisseursValides);
        Assert.assertTrue((boolean)fournisseursValides.isEmpty());
    }

    @Test
    public void testFiltrerFournisseursValidesEtAttente() {
        FournisseurFiltre listeFiltreFournisseurs = new FournisseurFiltre();
        FournisseurEtatControle filtreFournisseurValide = new FournisseurEtatControle("O");
        FournisseurEtatControle filtreFournisseurEnAttente = new FournisseurEtatControle("N");
        EOFournisUlr fournisseurValide = this.buildFournisseur("O", true);
        EOFournisUlr fournisseurEnAttente = this.buildFournisseur("N", true);
        EOFournisUlr fournisseurInvalide = this.buildFournisseur("A", true);
        List fournisseurs = new ArrayList<EOFournisUlr>();
        fournisseurs.add(fournisseurValide);
        fournisseurs.add(fournisseurEnAttente);
        fournisseurs.add(fournisseurInvalide);
        fournisseurs = listeFiltreFournisseurs.filtrer(fournisseurs, (IFiltre<K>[])new IFiltre[]{filtreFournisseurValide, filtreFournisseurEnAttente});
        Assert.assertEquals((long)2L, (long)fournisseurs.size());
    }

    private EOFournisUlr buildFournisseur(String etatFournisseur, boolean valide) {
        EOFournisUlr fournisseur = (EOFournisUlr)((Object)Mockito.mock(EOFournisUlr.class));
        Mockito.when((Object)fournisseur.isEtat(etatFournisseur)).thenReturn((Object)valide);
        return fournisseur;
    }
}

