/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.qualifier;

import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSSelector;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Qualifiers
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<QualifierKey, QualifierFactory> CONVERTERS = new HashMap<QualifierKey, QualifierFactory>(){
        {
            this.put(QualifierKey.PERSONNE_FOURNISSEUR_TYPE, new PersonneFournisseurTypeQualifierFactory());
            this.put(QualifierKey.PERSONNE_FOURNISSEUR_VALIDE, new PersonneFournisseurValideQualifierFactory());
            this.put(QualifierKey.REPART_PRS_ADR_TYPE, new RepartPersonneAdresseTypeQualifierFactory());
            this.put(QualifierKey.REPART_PRS_ADR_PRINCIPALE, new RepartPersonneAdressePrincipaleQualifierFactory());
            this.put(QualifierKey.CATALOGUE_FOUR_PRENOM_PERSONNE, new PrenomPersonneSearchQualifierFactory("fournisUlr"));
            this.put(QualifierKey.CATALOGUE_FOUR_NOM_PERSONNE, new NomPersonneSearchQualifierFactory("fournisUlr"));
            this.put(QualifierKey.PREST_FOUR_CLIENT_PRENOM_PERSONNE, new PrenomPersonneSearchQualifierFactory("fournisUlr"));
            this.put(QualifierKey.PREST_FOUR_CLIENT_NOM_PERSONNE, new NomPersonneSearchQualifierFactory("fournisUlr"));
            this.put(QualifierKey.FAP_FOUR_PREST_PRENOM_PERSONNE, new PrenomPersonneSearchQualifierFactory("fournisUlrPrest"));
            this.put(QualifierKey.FAP_FOUR_PREST_NOM_PERSONNE, new NomPersonneSearchQualifierFactory("fournisUlrPrest"));
            this.put(QualifierKey.FAP_FOUR_CLIENT_PRENOM_PERSONNE, new PrenomPersonneSearchQualifierFactory("fournisUlr"));
            this.put(QualifierKey.FAP_FOUR_CLIENT_NOM_PERSONNE, new NomPersonneSearchQualifierFactory("fournisUlr"));
        }
    };

    public static QualifierFactory getQualifierFactory(QualifierKey qualifierKey) {
        QualifierFactory qualifier = CONVERTERS.get((Object)qualifierKey);
        if (qualifier == null) {
            throw new IllegalArgumentException("No qualifier for type : " + qualifierKey.toString());
        }
        return qualifier;
    }

    private static class NomPersonneSearchQualifierFactory
    implements QualifierFactory {
        private static final String KEY;
        private String parentKey;

        static {
            StringBuilder qualifierKeyBuilder = new StringBuilder();
            qualifierKeyBuilder.append("personne").append(".").append("persLibelle");
            KEY = qualifierKeyBuilder.toString();
        }

        public NomPersonneSearchQualifierFactory(String parentKey) {
            this.parentKey = this.formatParentKey(parentKey);
        }

        public EOQualifier build(NSSelector selector, String value) {
            return new EOKeyValueQualifier(String.valueOf(this.parentKey) + KEY, selector, (Object)value);
        }

        private String formatParentKey(String originalParentKey) {
            String modifiedParentKey = originalParentKey;
            if (modifiedParentKey == null) {
                modifiedParentKey = "";
            }
            if (!modifiedParentKey.endsWith(".")) {
                modifiedParentKey = String.valueOf(modifiedParentKey) + ".";
            }
            return modifiedParentKey;
        }
    }

    private static class PersonneFournisseurTypeQualifierFactory
    implements QualifierFactory {
        private static final String KEY;

        static {
            StringBuilder qualFournisTypeKeyBuilder = new StringBuilder();
            qualFournisTypeKeyBuilder.append("personne").append(".").append("fournisUlrs").append(".").append("fouType");
            KEY = qualFournisTypeKeyBuilder.toString();
        }

        private PersonneFournisseurTypeQualifierFactory() {
        }

        public EOQualifier build(NSSelector selector, String value) {
            return new EOKeyValueQualifier(KEY, selector, (Object)value);
        }
    }

    private static class PersonneFournisseurValideQualifierFactory
    implements QualifierFactory {
        private static final String KEY;

        static {
            StringBuilder qualFournisValideKeyBuilder = new StringBuilder();
            qualFournisValideKeyBuilder.append("personne").append(".").append("fournisUlrs").append(".").append("fouValide");
            KEY = qualFournisValideKeyBuilder.toString();
        }

        private PersonneFournisseurValideQualifierFactory() {
        }

        public EOQualifier build(NSSelector selector, String value) {
            return new EOKeyValueQualifier(KEY, selector, (Object)value);
        }
    }

    private static class PrenomPersonneSearchQualifierFactory
    implements QualifierFactory {
        private static final String KEY;
        private String parentKey;

        static {
            StringBuilder qualifierKeyBuilder = new StringBuilder();
            qualifierKeyBuilder.append("personne").append(".").append("persLc");
            KEY = qualifierKeyBuilder.toString();
        }

        public PrenomPersonneSearchQualifierFactory(String parentKey) {
            this.parentKey = this.formatParentKey(parentKey);
        }

        public EOQualifier build(NSSelector selector, String value) {
            return new EOKeyValueQualifier(String.valueOf(this.parentKey) + KEY, selector, (Object)value);
        }

        private String formatParentKey(String originalParentKey) {
            String modifiedParentKey = originalParentKey;
            if (modifiedParentKey == null) {
                modifiedParentKey = "";
            }
            if (!modifiedParentKey.endsWith(".")) {
                modifiedParentKey = String.valueOf(modifiedParentKey) + ".";
            }
            return modifiedParentKey;
        }
    }

    public static interface QualifierFactory {
        public EOQualifier build(NSSelector var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QualifierKey {
        PERSONNE_FOURNISSEUR_TYPE,
        PERSONNE_FOURNISSEUR_VALIDE,
        REPART_PRS_ADR_TYPE,
        REPART_PRS_ADR_PRINCIPALE,
        CATALOGUE_FOUR_PRENOM_PERSONNE,
        CATALOGUE_FOUR_NOM_PERSONNE,
        PREST_FOUR_CLIENT_PRENOM_PERSONNE,
        PREST_FOUR_CLIENT_NOM_PERSONNE,
        FAP_FOUR_PREST_PRENOM_PERSONNE,
        FAP_FOUR_PREST_NOM_PERSONNE,
        FAP_FOUR_CLIENT_PRENOM_PERSONNE,
        FAP_FOUR_CLIENT_NOM_PERSONNE;

    }

    private static class RepartPersonneAdressePrincipaleQualifierFactory
    implements QualifierFactory {
        private RepartPersonneAdressePrincipaleQualifierFactory() {
        }

        public EOQualifier build(NSSelector selector, String value) {
            return new EOKeyValueQualifier("rpaPrincipal", selector, (Object)value);
        }
    }

    private static class RepartPersonneAdresseTypeQualifierFactory
    implements QualifierFactory {
        private RepartPersonneAdresseTypeQualifierFactory() {
        }

        public EOQualifier build(NSSelector selector, String value) {
            return new EOKeyValueQualifier("tadrCode", selector, (Object)value);
        }
    }
}

