/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.qualifier;

import com.webobjects.eocontrol.EOQualifier;
import java.util.ArrayList;
import org.cocktail.application.client.eof.EOExercice;
import org.cocktail.kava.client.qualifier.PlanComptableCtpQualifiers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PlanComptableCtpQualifiersTest {
    private static final String PCO_PATH = "planComptable";
    private static final String PCO_NUM_PATH = "pcoNum";
    private static final String CLASSE_1_INTERDITE = "1";

    @Test
    public void testInstance() {
        Assert.assertNotNull((Object)PlanComptableCtpQualifiers.instance());
    }

    @Test
    public void testBuildTypeEtatValide() {
        PlanComptableCtpQualifiers pcoCtpQualifiersBuilder = PlanComptableCtpQualifiers.instance();
        EOQualifier typeValideQualifier = pcoCtpQualifiersBuilder.buildTypeEtatValide(PCO_PATH);
        Assert.assertEquals((Object)"(planComptable.pcoValidite = 'VALIDE')", (Object)typeValideQualifier.toString());
    }

    @Test
    public void testBuildExercice() {
        PlanComptableCtpQualifiers pcoCtpQualifiersBuilder = PlanComptableCtpQualifiers.instance();
        EOExercice exercice = (EOExercice)Mockito.mock(EOExercice.class);
        Assert.assertNull((Object)pcoCtpQualifiersBuilder.buildExercice(PCO_PATH, null));
        EOQualifier exerciceQualifier = pcoCtpQualifiersBuilder.buildExercice(PCO_PATH, exercice);
        Assert.assertNotNull((Object)exerciceQualifier);
        Assert.assertEquals((long)1L, (long)exerciceQualifier.allQualifierKeys().count());
        Assert.assertEquals((Object)"planComptable.exercice", (Object)exerciceQualifier.allQualifierKeys().toArray()[0]);
    }

    @Test
    public void testBuildClassesInterdites() {
        PlanComptableCtpQualifiers pcoCtpQualifiersBuilder = PlanComptableCtpQualifiers.instance();
        Assert.assertNull((Object)pcoCtpQualifiersBuilder.buildClassesInterdites(PCO_NUM_PATH, null));
        ArrayList<String> classesInterdites = new ArrayList<String>();
        classesInterdites.add(CLASSE_1_INTERDITE);
        EOQualifier classesInterditesQualifier = pcoCtpQualifiersBuilder.buildClassesInterdites(PCO_NUM_PATH, classesInterdites);
        Assert.assertNotNull((Object)classesInterditesQualifier);
        Assert.assertEquals((Object)"(not ((pcoNum like '1*')))", (Object)classesInterditesQualifier.toString());
    }
}

