/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.metier;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSValidation;
import org.cocktail.kava.client.finder.FinderTauxProrata;
import org.cocktail.kava.client.metier.EORecetteCtrlAction;
import org.cocktail.kava.client.metier.EORecetteCtrlAnalytique;
import org.cocktail.kava.client.metier.EORecetteCtrlConvention;
import org.cocktail.kava.client.metier.EORecetteCtrlPlanco;
import org.cocktail.kava.client.metier._EORecette;

public class EORecette
extends _EORecette {
    public static final String PRIMARY_KEY_KEY = "recId";

    public boolean updateTauxProrata() {
        boolean isDirty = false;
        if (this.tauxProrata() == null) {
            this.setTauxProrataRelationship(FinderTauxProrata.tauxProrata100(this.editingContext()));
            isDirty = true;
        }
        return isDirty;
    }

    public boolean hasMultipleCtrls() {
        return this.hasMultipleCtrlActions() || this.hasMultipleCtrlAnalytiques() || this.hasMultipleCtrlConventions() || this.hasMultipleCtrlPlancos() || this.hasMultipleCtrlPlancoTvas() || this.hasMultipleCtrlPlancoCtps();
    }

    public boolean hasMultipleCtrlActions() {
        return this.recetteCtrlActions() != null && this.recetteCtrlActions().count() > 1;
    }

    public boolean hasMultipleCtrlAnalytiques() {
        return this.recetteCtrlAnalytiques() != null && this.recetteCtrlAnalytiques().count() > 1;
    }

    public boolean hasMultipleCtrlConventions() {
        return this.recetteCtrlConventions() != null && this.recetteCtrlConventions().count() > 1;
    }

    public boolean hasMultipleCtrlPlancos() {
        return this.recetteCtrlPlancos() != null && this.recetteCtrlPlancos().count() > 1;
    }

    public boolean hasMultipleCtrlPlancoTvas() {
        if (this.recetteCtrlPlancos() == null || this.recetteCtrlPlancos().count() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.recetteCtrlPlancos().count()) {
            EORecetteCtrlPlanco rpco = (EORecetteCtrlPlanco)((Object)this.recetteCtrlPlancos().objectAtIndex(i));
            if (rpco.recetteCtrlPlancoTvas() != null && rpco.recetteCtrlPlancoTvas().count() > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasMultipleCtrlPlancoCtps() {
        if (this.recetteCtrlPlancos() == null || this.recetteCtrlPlancos().count() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.recetteCtrlPlancos().count()) {
            EORecetteCtrlPlanco rpco = (EORecetteCtrlPlanco)((Object)this.recetteCtrlPlancos().objectAtIndex(i));
            if (rpco.recetteCtrlPlancoCtps() != null && rpco.recetteCtrlPlancoCtps().count() > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isTitred() {
        return this.titId() != null;
    }

    public boolean isVised() {
        if (!this.isTitred()) {
            return false;
        }
        if (this.recetteCtrlPlancos() != null) {
            int i = 0;
            while (i < this.recetteCtrlPlancos().count()) {
                EORecetteCtrlPlanco rpco = (EORecetteCtrlPlanco)((Object)this.recetteCtrlPlancos().objectAtIndex(i));
                if (rpco.titre() != null && rpco.titre().titEtat() != null && rpco.titre().titEtat().equalsIgnoreCase("VISE")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void validateForInsert() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForInsert();
    }

    public void validateForUpdate() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForUpdate();
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        super.validateForDelete();
    }

    public void validateForSave() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForSave();
    }

    public void validateObjectMetier() throws NSValidation.ValidationException {
        if (this.recDateSaisie() == null) {
            throw new NSValidation.ValidationException("Il faut une date de creation pour la recette!");
        }
        if (this.recHtSaisie() == null) {
            throw new NSValidation.ValidationException("Il faut un montant HT pour la recette!");
        }
        if (this.recTtcSaisie() == null) {
            throw new NSValidation.ValidationException("Il faut un montant TTC pour la recette!");
        }
        if (this.exercice() == null) {
            throw new NSValidation.ValidationException("Il faut un exercice pour la recette!");
        }
        if (this.facture() == null) {
            throw new NSValidation.ValidationException("Il faut une facture client pour la recette!");
        }
        if (this.utilisateur() == null) {
            throw new NSValidation.ValidationException("Il faut un utilisateur (agent) pour la recette!");
        }
        if (this.recetteCtrlActions() == null || this.recetteCtrlActions().count() == 0) {
            throw new NSValidation.ValidationException("Il faut au moins une action lolf renseignee pour la recette!!");
        }
        if (this.recetteCtrlPlancos() == null || this.recetteCtrlPlancos().count() == 0) {
            throw new NSValidation.ValidationException("Il faut au moins un plan comptable pour la recette!!");
        }
        if (this.recettePapier() == null) {
            throw new NSValidation.ValidationException("Il faut une recette papier de rattachement pour la recette!");
        }
        if (this.recettePapier().modeRecouvrement() == null) {
            throw new NSValidation.ValidationException("Il faut un mode de recouvrement pour la recette!");
        }
        if (this.recettePapier().rppNbPiece() == null) {
            throw new NSValidation.ValidationException("Il faut un nombre de pieces pour la recette!");
        }
    }

    public void validateObjectMetierWithFacture() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        if (this.facture().personne() == null) {
            throw new NSValidation.ValidationException("Il faut un client pour la recette!");
        }
        if (this.facture().organ() == null) {
            throw new NSValidation.ValidationException("Il faut une ligne budgetaire pour la recette!");
        }
        if (this.facture().typeCreditRec() == null) {
            throw new NSValidation.ValidationException("Il faut un type de credit recette pour la recette!");
        }
        if (this.facture().typeApplication() == null) {
            throw new NSValidation.ValidationException("Il faut un type d'application pour la recette!");
        }
    }

    private final void validateBeforeTransactionSave() throws NSValidation.ValidationException {
    }

    public void setRecetteCtrlActions(NSMutableArray nsMutableArray) {
        int i = 0;
        while (i < nsMutableArray.count()) {
            this.addToRecetteCtrlActionsRelationship((EORecetteCtrlAction)((Object)nsMutableArray.objectAtIndex(i)));
            ++i;
        }
    }

    public void setRecetteCtrlAnalytiques(NSMutableArray nsMutableArray) {
        int i = 0;
        while (i < nsMutableArray.count()) {
            this.addToRecetteCtrlAnalytiquesRelationship((EORecetteCtrlAnalytique)((Object)nsMutableArray.objectAtIndex(i)));
            ++i;
        }
    }

    public void setRecetteCtrlConventions(NSMutableArray nsMutableArray) {
        int i = 0;
        while (i < nsMutableArray.count()) {
            this.addToRecetteCtrlConventionsRelationship((EORecetteCtrlConvention)((Object)nsMutableArray.objectAtIndex(i)));
            ++i;
        }
    }

    public void setRecetteCtrlPlancos(NSMutableArray nsMutableArray) {
        int i = 0;
        while (i < nsMutableArray.count()) {
            this.addToRecetteCtrlPlancosRelationship((EORecetteCtrlPlanco)((Object)nsMutableArray.objectAtIndex(i)));
            ++i;
        }
    }
}

