/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.metier;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSValidation;
import java.util.ArrayList;
import java.util.List;
import org.cocktail.kava.client.PieFwkUtilities;
import org.cocktail.kava.client.metier.EOFournisUlr;
import org.cocktail.kava.client.metier._EOPersonne;
import org.cocktail.kava.client.selector.FournisseurEtatControle;
import org.cocktail.kava.client.selector.FournisseurFiltre;
import org.cocktail.pieFwk.selector.IFiltre;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOPersonne
extends _EOPersonne {
    public static final String PERS_NOM_PRENOM_KEY = "persNomPrenom";
    public static final String PRIMARY_KEY_KEY = "persId";
    public static final String FOURNISSEUR_JOIN_KEY = "fournisUlrs";
    public static final IFiltre<EOFournisUlr> FILTRE_FOURNISSEUR_VALIDE = new FournisseurEtatControle("O");
    public static final IFiltre<EOFournisUlr> FILTRE_FOURNISSEUR_EN_ATTENTE = new FournisseurEtatControle("N");

    public boolean isPersonneMorale() {
        return "STR".equalsIgnoreCase(this.persType());
    }

    public String persNomPrenom() {
        return PieFwkUtilities.capitalizedString(this.persLibelle().concat(PieFwkUtilities.isEmpty(this.persLc()) ? "" : " ".concat(this.persLc())));
    }

    public List<EOFournisUlr> fournisseurs(IFiltre<EOFournisUlr> ... filtres) {
        FournisseurFiltre fournisseurFiltre = new FournisseurFiltre();
        List<EOFournisUlr> fournisseurs = this.fournisUlrAsList();
        return fournisseurFiltre.filtrer(fournisseurs, (IFiltre<K>[])filtres);
    }

    private List<EOFournisUlr> fournisUlrAsList() {
        ArrayList<EOFournisUlr> fournisseurs = new ArrayList<EOFournisUlr>();
        NSArray fournisseursAsArray = this.fournisUlrs();
        if (fournisseursAsArray == null || fournisseursAsArray.count() == 0) {
            return fournisseurs;
        }
        int idx = 0;
        while (idx < fournisseursAsArray.count()) {
            fournisseurs.add((EOFournisUlr)((Object)fournisseursAsArray.objectAtIndex(idx)));
            ++idx;
        }
        return fournisseurs;
    }

    public void validateForInsert() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForInsert();
    }

    public void validateForUpdate() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForUpdate();
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        super.validateForDelete();
    }

    public void validateForSave() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForSave();
    }

    public void validateObjectMetier() throws NSValidation.ValidationException {
    }

    private final void validateBeforeTransactionSave() throws NSValidation.ValidationException {
    }
}

