/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.metier;

import com.webobjects.eoapplication.EOApplication;
import com.webobjects.foundation.NSValidation;
import java.math.BigDecimal;
import org.cocktail.kava.client.metier.EOTva;
import org.cocktail.kava.client.metier._EOFacturePapierLigne;
import org.cocktail.pieFwk.common.ApplicationConfig;
import org.cocktail.pieFwk.common.metier.FacturePapier;
import org.cocktail.pieFwk.common.metier.FacturePapierLigne;
import org.cocktail.pieFwk.common.metier.FacturePapierLigneCompanion;
import org.cocktail.pieFwk.common.metier.PrestationLigne;
import org.cocktail.pieFwk.common.metier.TauxTva;

public class EOFacturePapierLigne
extends _EOFacturePapierLigne
implements FacturePapierLigne {
    public static final String FLIG_TOTAL_TVA_KEY = "fligTotalTva";
    private FacturePapierLigneCompanion companion = new FacturePapierLigneCompanion(this);

    public FacturePapierLigneCompanion companion() {
        return this.companion;
    }

    public void setTvaRelationship(EOTva value) {
        super.setTvaRelationship(value);
        this.companion.updateTotaux();
    }

    public void setFligArtHt(BigDecimal aValue) {
        super.setFligArtHt(aValue);
        this.companion.updateTotalHt();
    }

    public void setFligArtTtc(BigDecimal aValue) {
        super.setFligArtTtc(aValue);
        this.companion.updateTotalTtc();
    }

    public BigDecimal fligTotalTva() {
        if (this.fligTotalTtc() == null) {
            return new BigDecimal(0.0);
        }
        if (this.fligTotalHt() == null) {
            return this.fligTotalTtc();
        }
        return this.fligTotalTtc().subtract(this.fligTotalHt());
    }

    public void validateForInsert() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForInsert();
    }

    public void validateForUpdate() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForUpdate();
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        super.validateForDelete();
    }

    public void validateForSave() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForSave();
    }

    public void validateObjectMetier() throws NSValidation.ValidationException {
        if (this.typeArticle() == null) {
            throw new NSValidation.ValidationException("Il faut un type article pour les lignes de la facture papier!");
        }
        if (this.facturePapier() == null) {
            throw new NSValidation.ValidationException("Il faut une facture papier pour les lignes de la facture papier!");
        }
        if (this.fligDate() == null) {
            throw new NSValidation.ValidationException("Il faut une date de creation pour les lignes de la facture papier!");
        }
        if (this.fligDescription() == null) {
            throw new NSValidation.ValidationException("Il faut un libelle pour les lignes de la facture papier!");
        }
        if (this.fligArtHt() == null) {
            throw new NSValidation.ValidationException("Il faut un prix HT pour les lignes de la facture papier!");
        }
        if (this.fligArtTtc() == null) {
            throw new NSValidation.ValidationException("Il faut un prix TTC pour les lignes de la facture papier!");
        }
        if (this.fligQuantite() == null) {
            throw new NSValidation.ValidationException("Il faut une quantite pour les lignes de la facture papier!");
        }
        if (this.fligArtHt().abs().compareTo(this.fligArtTtc().abs()) == 1) {
            throw new NSValidation.ValidationException("Le prix HT ne peut etre superieur au prix TTC!");
        }
    }

    private final void validateBeforeTransactionSave() throws NSValidation.ValidationException {
    }

    public void addToFacturePapierLignesRelationship(FacturePapierLigne ligne) {
        this.addToFacturePapierLignesRelationship((EOFacturePapierLigne)ligne);
    }

    public FacturePapier getFacturePapierCommon() {
        return this.facturePapier();
    }

    public PrestationLigne getPrestationLigneCommon() {
        return this.prestationLigne();
    }

    public TauxTva tauxTva() {
        return this.tva();
    }

    public ApplicationConfig applicationConfig() {
        return (ApplicationConfig)EOApplication.sharedApplication();
    }

    public Number exerciceAsNumber() {
        if (this.facturePapier() != null && this.facturePapier().exercice() != null) {
            return this.facturePapier().exercice().exeExercice();
        }
        return null;
    }
}

