/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.metier;

import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValidation;
import java.sql.Timestamp;
import org.cocktail.kava.client.PieFwkUtilities;
import org.cocktail.kava.client.metier._EOCatalogue;

public class EOCatalogue
extends _EOCatalogue {
    public String periodeValidite() {
        StringBuffer periode = new StringBuffer();
        NSTimestamp debut = this.catDateDebut();
        NSTimestamp fin = this.catDateFin();
        if (debut != null) {
            periode.append(PieFwkUtilities.datToString(debut, "%d/%m/%Y"));
        } else {
            periode.append("?");
        }
        periode.append("-");
        if (fin != null) {
            periode.append(PieFwkUtilities.datToString(fin, "%d/%m/%Y"));
        } else {
            periode.append("?");
        }
        return periode.toString();
    }

    public String compCatLibelle() {
        return "[" + this.typeEtat().tyetLibelle() + "] " + this.catLibelle();
    }

    public void validateForInsert() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForInsert();
    }

    public void validateForUpdate() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForUpdate();
    }

    public void validateForDelete() throws NSValidation.ValidationException {
        super.validateForDelete();
    }

    public void validateForSave() throws NSValidation.ValidationException {
        this.validateObjectMetier();
        this.validateBeforeTransactionSave();
        super.validateForSave();
    }

    public void validateObjectMetier() throws NSValidation.ValidationException {
        if (this.catDateDebut() == null) {
            throw new NSValidation.ValidationException("Il faut une date de debut de validite pour le catalogue!");
        }
        if (this.catLibelle() == null) {
            throw new NSValidation.ValidationException("Il faut un libelle pour le catalogue!");
        }
        if (this.catCommentaire() == null) {
            throw new NSValidation.ValidationException("Il faut un commentaire pour le catalogue!");
        }
        if (this.fournisUlr() == null) {
            throw new NSValidation.ValidationException("Il faut un fournisseur (prestataire) pour le catalogue!");
        }
        if (this.catDateFin() != null && this.catDateDebut().after((Timestamp)this.catDateFin())) {
            throw new NSValidation.ValidationException("Il serait sans doute judicieux que la date de debut de validite du catalogue soit AVANT la date de fin!");
        }
    }

    private final void validateBeforeTransactionSave() throws NSValidation.ValidationException {
    }
}

