/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.finder;

import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import java.text.MessageFormat;
import org.cocktail.application.client.eof.EOExercice;
import org.cocktail.kava.client.finder.FinderTypeEtat;
import org.cocktail.kava.client.metier.EOOrgan;
import org.cocktail.kava.client.metier.EOTauxProrata;
import org.cocktail.pieFwk.common.exception.NoResultException;
import org.cocktail.pieFwk.common.exception.NonUniqueResultException;

public class FinderTauxProrata {
    private static final String NO_RESULT_EXCEPTION = "Le taux de prorata {0} % n''existe pas ou n''est pas valide.";
    private static final String NON_UNIQUE_RESULT_EXCEPTION = "Plusieurs enregistrements existent pour le taux de prorata {0} %. Merci de prendre contact avec votre service informatique.";
    private static final Integer TX_PRORATA_100_AS_INT = 100;
    private static EOTauxProrata TX_PRORATA_100;

    public static EOTauxProrata tauxProrata100(EOEditingContext ec) {
        if (TX_PRORATA_100 == null || TX_PRORATA_100.editingContext() == null) {
            TX_PRORATA_100 = FinderTauxProrata.findByTaux(ec, TX_PRORATA_100_AS_INT);
        }
        return TX_PRORATA_100.localInstanceIn(ec);
    }

    public static NSArray find(EOEditingContext ec, EOOrgan organ, EOExercice exercice) {
        NSMutableArray quals = new NSMutableArray();
        quals.addObject((Object)FinderTauxProrata.qualTypeEtatValide(ec));
        if (organ != null) {
            quals.addObject((Object)EOQualifier.qualifierWithQualifierFormat((String)"organProratas.organ = %@", (NSArray)new NSArray((Object)organ)));
        }
        if (exercice != null) {
            quals.addObject((Object)EOQualifier.qualifierWithQualifierFormat((String)"organProratas.exercice = %@", (NSArray)new NSArray((Object)exercice)));
        }
        EOFetchSpecification fs = new EOFetchSpecification("TauxProrata", (EOQualifier)new EOAndQualifier((NSArray)quals), new NSArray(new Object[]{EOSortOrdering.sortOrderingWithKey((String)"organProratas.orpPriorite", (NSSelector)EOSortOrdering.CompareAscending), EOSortOrdering.sortOrderingWithKey((String)"tapTaux", (NSSelector)EOSortOrdering.CompareAscending)}));
        try {
            return ec.objectsWithFetchSpecification(fs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new NSArray();
        }
    }

    public static EOTauxProrata findByTaux(EOEditingContext ec, Number tauxProrata) {
        NSMutableArray quals = new NSMutableArray();
        quals.addObject((Object)FinderTauxProrata.qualTypeEtatValide(ec));
        quals.addObject((Object)FinderTauxProrata.qualTauxProrata(tauxProrata));
        EOFetchSpecification fs = new EOFetchSpecification("TauxProrata", (EOQualifier)new EOAndQualifier((NSArray)quals), null);
        NSArray tauxProrataResults = ec.objectsWithFetchSpecification(fs);
        if (tauxProrataResults.count() == 0) {
            throw new NoResultException(MessageFormat.format(NO_RESULT_EXCEPTION, tauxProrata));
        }
        if (tauxProrataResults.count() > 1) {
            throw new NonUniqueResultException(MessageFormat.format(NON_UNIQUE_RESULT_EXCEPTION, tauxProrata));
        }
        return (EOTauxProrata)((Object)tauxProrataResults.objectAtIndex(0));
    }

    private static EOQualifier qualTypeEtatValide(EOEditingContext ec) {
        return EOQualifier.qualifierWithQualifierFormat((String)"typeEtat= %@", (NSArray)new NSArray((Object)FinderTypeEtat.typeEtatValide(ec)));
    }

    private static EOQualifier qualTauxProrata(Number tauxProrata) {
        return EOQualifier.qualifierWithQualifierFormat((String)"tapTaux= %@", (NSArray)new NSArray((Object)tauxProrata));
    }
}

