/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.factory;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSTimestamp;
import org.cocktail.kava.client.factory.Factory;
import org.cocktail.kava.client.finder.FinderPlanComptable;
import org.cocktail.kava.client.metier.EOCatalogueArticle;
import org.cocktail.kava.client.metier.EOPlanComptable;
import org.cocktail.kava.client.metier.EOPrestation;
import org.cocktail.kava.client.metier.EOPrestationLigne;

public class FactoryPrestationLigne
extends Factory {
    private static final String COMPTE_INVALIDE = "Le compte d''imputation {0} est invalide pour l''exercice s\u00e9lectionn\u00e9.";

    public FactoryPrestationLigne() {
    }

    public FactoryPrestationLigne(boolean withLog) {
        super(withLog);
    }

    public static EOPrestationLigne newObject(EOEditingContext ec, EOPrestation prestation, EOCatalogueArticle catalogueArticle) {
        EOPrestationLigne object = FactoryPrestationLigne.createNewObject(ec, prestation, catalogueArticle);
        object.setPrestationRelationship(prestation);
        if (object.prestation() != null && "N".equalsIgnoreCase(object.prestation().prestApplyTva())) {
            object.setTvaRelationship(null);
            object.setPrligArtTtc(object.prligArtHt());
        }
        return object;
    }

    public static EOPrestationLigne newObject(EOEditingContext ec, EOPrestationLigne prestationLigne, EOCatalogueArticle catalogueArticle) {
        EOPrestation prestationParent = null;
        if (prestationLigne != null && prestationLigne.prestation() != null) {
            prestationParent = prestationLigne.prestation();
        }
        EOPrestationLigne object = FactoryPrestationLigne.createNewObject(ec, prestationParent, catalogueArticle);
        if (prestationLigne != null) {
            object.setPrestationLignePereRelationship(prestationLigne);
            object.setPrestationRelationship(prestationLigne.prestation());
            if (object.prestation() != null && "N".equalsIgnoreCase(object.prestation().prestApplyTva())) {
                object.setTvaRelationship(null);
                object.setPrligArtTtc(object.prligArtHt());
            }
            object.setPrligQuantite(prestationLigne.prligQuantite());
            object.setPrligQuantiteReste(prestationLigne.prligQuantiteReste());
        }
        return object;
    }

    private static EOPrestationLigne createNewObject(EOEditingContext ec, EOPrestation prestationParent, EOCatalogueArticle catalogueArticle) {
        EOPrestationLigne object = FactoryPrestationLigne.newObject(ec);
        object.setCatalogueArticleRelationship(catalogueArticle);
        if (catalogueArticle != null) {
            object.setPrligArtHt(catalogueArticle.caarPrixHt());
            object.setPrligArtTtc(catalogueArticle.caarPrixTtc());
            object.setPrligArtTtcInitial(catalogueArticle.caarPrixTtc());
            object.setTvaRelationship(catalogueArticle.tva());
            object.setTvaInitialRelationship(catalogueArticle.tva());
            object.setPrligDescription(catalogueArticle.article().artLibelle());
            object.setPrligReference(catalogueArticle.caarReference());
            object.setTypeArticleRelationship(catalogueArticle.article().typeArticle());
            EOPlanComptable compte = FinderPlanComptable.findOnlyValid(ec, prestationParent.exercice(), catalogueArticle.article().articlePrestation().pcoNumRecette());
            if (compte != null) {
                object.setPcoNum(compte.pcoNum());
            }
        }
        return object;
    }

    public static EOPrestationLigne newObject(EOEditingContext ec, EOPrestation prestation, EOPrestationLigne article) {
        EOPrestationLigne object = FactoryPrestationLigne.newObject(ec);
        object.setCatalogueArticleRelationship(article.catalogueArticle());
        object.setPrestationRelationship(prestation);
        object.setPrligDate(new NSTimestamp());
        object.setPrligReference(article.prligReference());
        object.setPrligDescription(article.prligDescription());
        object.setPrligArtHt(article.prligArtHt());
        object.setPrligArtTtc(article.prligArtTtc());
        object.setPrligArtTtcInitial(article.prligArtTtcInitial());
        object.setPrligTotalHt(article.prligTotalHt());
        object.setPrligTotalTtc(article.prligTotalTtc());
        object.setPrligTotalResteHt(article.prligTotalResteHt());
        object.setPrligTotalResteTtc(article.prligTotalResteTtc());
        object.setPrligQuantite(article.prligQuantite());
        object.setPrligQuantiteReste(article.prligQuantiteReste());
        object.setTvaRelationship(article.tva());
        object.setTvaInitialRelationship(article.tvaInitial());
        object.setTypeArticleRelationship(article.typeArticle());
        object.setPcoNum(article.pcoNum());
        return object;
    }

    private static EOPrestationLigne newObject(EOEditingContext ec) {
        EOPrestationLigne object = (EOPrestationLigne)Factory.instanceForEntity(ec, "PrestationLigne");
        object.setPrligDate(new NSTimestamp());
        ec.insertObject((EOEnterpriseObject)object);
        return object;
    }

    public static void removeObject(EOEditingContext ec, EOPrestationLigne lignePrestation, EOPrestationLigne prestationLignePere) {
        if (lignePrestation == null) {
            return;
        }
        if (ec != null) {
            ec.deleteObject((EOEnterpriseObject)lignePrestation);
        }
        if (prestationLignePere != null) {
            prestationLignePere.removeFromPrestationLignesRelationship(lignePrestation);
        }
        if (lignePrestation.prestation() != null) {
            lignePrestation.prestation().removeFromPrestationLignesRelationship(lignePrestation);
        }
    }
}

