/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.factory;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSValidation;
import org.cocktail.kava.client.factory.Factory;
import org.cocktail.kava.client.finder.FinderTauxProrata;
import org.cocktail.kava.client.finder.FinderTypeEtat;
import org.cocktail.kava.client.metier.EOPrestation;
import org.cocktail.kava.client.metier.EOUtilisateur;
import org.cocktail.kava.client.procedures.ApiPrestation;
import org.cocktail.pieFwk.common.exception.EntityInitializationException;
import org.cocktail.pieFwk.common.exception.NoResultException;
import org.cocktail.pieFwk.common.exception.NonUniqueResultException;

public class FactoryPrestation
extends Factory {
    public FactoryPrestation() {
    }

    public FactoryPrestation(boolean withLog) {
        super(withLog);
    }

    public static EOPrestation newObject(EOEditingContext ec) throws EntityInitializationException {
        try {
            EOPrestation prestation = (EOPrestation)Factory.instanceForEntity(ec, "Prestation");
            prestation.setTypeEtatRelationship(FinderTypeEtat.typeEtatValide(ec));
            prestation.setPrestDate(Factory.getDateJour());
            prestation.setTauxProrataRelationship(FinderTauxProrata.tauxProrata100(ec));
            ec.insertObject((EOEnterpriseObject)prestation);
            return prestation;
        }
        catch (NoResultException nre) {
            throw new EntityInitializationException(nre.getMessage());
        }
        catch (NonUniqueResultException nure) {
            throw new EntityInitializationException(nure.getMessage());
        }
    }

    public static void valideClient(EOEditingContext ec, EOPrestation prestation, EOUtilisateur utilisateur) throws Exception {
        if (prestation == null) {
            return;
        }
        if (prestation.prestDateValideClient() != null) {
            return;
        }
        if (prestation.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La prestation " + prestation.prestNumero() + " est archivee, impossible de la valider !");
        }
        if (!prestation.isValidableClient()) {
            throw new Exception("Il manque des informations budgetaires cote client, impossible de valider la prestation " + prestation.prestNumero() + " !");
        }
        ApiPrestation.validePrestationClient(ec, prestation, utilisateur);
        if (prestation.prestationLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(prestation.prestationLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)prestation)));
    }

    public static void devalideClient(EOEditingContext ec, EOPrestation prestation, EOUtilisateur utilisateur) throws Exception {
        if (prestation == null) {
            return;
        }
        if (prestation.prestDateValideClient() == null) {
            return;
        }
        if (prestation.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La prestation " + prestation.prestNumero() + " est archivee, impossible de la devalider !");
        }
        FactoryPrestation.decloture(ec, prestation, utilisateur);
        FactoryPrestation.devalidePrestataire(ec, prestation, utilisateur);
        ApiPrestation.devalidePrestationClient(ec, prestation, utilisateur);
        if (prestation.prestationLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(prestation.prestationLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)prestation)));
    }

    public static void validePrestataire(EOEditingContext ec, EOPrestation prestation, EOUtilisateur utilisateur) throws Exception {
        if (prestation == null) {
            return;
        }
        if (prestation.prestDateValidePrest() != null) {
            return;
        }
        if (prestation.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La prestation " + prestation.prestNumero() + " est archivee, impossible de la valider !");
        }
        if (!prestation.isValidablePrest()) {
            throw new Exception("Il manque des informations budgetaires cote prestataire, impossible de valider la prestation " + prestation.prestNumero() + " !");
        }
        FactoryPrestation.valideClient(ec, prestation, utilisateur);
        ApiPrestation.validePrestationPrestataire(ec, prestation, utilisateur);
        if (prestation.prestationLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(prestation.prestationLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)prestation)));
    }

    public static void devalidePrestataire(EOEditingContext ec, EOPrestation prestation, EOUtilisateur utilisateur) throws Exception {
        if (prestation == null) {
            return;
        }
        if (prestation.prestDateValidePrest() == null) {
            return;
        }
        if (prestation.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La prestation " + prestation.prestNumero() + " est archivee, impossible de la devalider !");
        }
        FactoryPrestation.decloture(ec, prestation, utilisateur);
        ApiPrestation.devalidePrestationPrestataire(ec, prestation, utilisateur);
        if (prestation.prestationLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(prestation.prestationLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)prestation)));
    }

    public static void cloture(EOEditingContext ec, EOPrestation prestation, EOUtilisateur utilisateur) throws Exception {
        if (prestation == null) {
            return;
        }
        if (prestation.prestDateCloture() != null) {
            return;
        }
        if (prestation.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La prestation " + prestation.prestNumero() + " est archivee, impossible de la cloturer !");
        }
        if (!prestation.isCloturable()) {
            throw new Exception("Il manque des informations, impossible de cloturer la prestation " + prestation.prestNumero() + " !");
        }
        FactoryPrestation.valideClient(ec, prestation, utilisateur);
        FactoryPrestation.validePrestataire(ec, prestation, utilisateur);
        ApiPrestation.cloturePrestation(ec, prestation, utilisateur);
        if (prestation.prestationLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(prestation.prestationLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)prestation)));
    }

    public static void decloture(EOEditingContext ec, EOPrestation prestation, EOUtilisateur utilisateur) throws Exception {
        if (prestation == null) {
            return;
        }
        if (prestation.prestDateCloture() == null) {
            return;
        }
        if (prestation.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La prestation " + prestation.prestNumero() + " est archivee, impossible de la \"decloturer\" !");
        }
        if (prestation.prestDateFacturation() != null || prestation.facturePapiers() != null && prestation.facturePapiers().count() > 0) {
            throw new Exception("La prestation " + prestation.prestNumero() + " est deja facturee, impossible de la \"decloturer\" !");
        }
        ApiPrestation.decloturePrestation(ec, prestation, utilisateur);
        if (prestation.prestationLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(prestation.prestationLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)prestation)));
    }

    public static void genereFacture(EOEditingContext ec, EOPrestation prestation, EOUtilisateur utilisateur) throws Exception {
        if (prestation == null) {
            return;
        }
        if (prestation.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La prestation " + prestation.prestNumero() + " est archivee, impossible de la facturer !");
        }
        if (prestation.prestDateCloture() == null) {
            throw new Exception("La prestation " + prestation.prestNumero() + " n'est pas cloturee, impossible de la facturer !");
        }
        if (!prestation.isFacturable()) {
            throw new Exception("Il manque des informations, impossible de facturer la prestation " + prestation.prestNumero() + " !");
        }
        ApiPrestation.genereFacturePapier(ec, prestation, utilisateur);
        if (prestation.prestationLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(prestation.prestationLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)prestation)));
    }

    public static void archivePrestation(EOEditingContext ec, EOPrestation prestation, EOUtilisateur utilisateur) throws Exception {
        if (prestation.prestDateValideClient() != null) {
            FactoryPrestation.devalideClient(ec, prestation, utilisateur);
        }
        ApiPrestation.archivePrestation(ec, prestation, utilisateur);
        if (prestation.prestationLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(prestation.prestationLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)prestation)));
    }

    public static void reactivePrestation(EOEditingContext ec, EOPrestation prestation) throws Exception {
        try {
            prestation.setTypeEtatRelationship(FinderTypeEtat.typeEtatValide(ec));
            ec.saveChanges();
        }
        catch (NSValidation.ValidationException ve) {
            ec.revert();
            throw ve;
        }
    }

    public static boolean regrouperPrestation(EOEditingContext ec, NSArray arrayPrestations, EOUtilisateur utilisateur) {
        try {
            ApiPrestation.regrouperPrestation(ec, arrayPrestations, utilisateur);
        }
        catch (Exception e) {
            if (e instanceof Exception) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }
}

