/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.factory;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import org.cocktail.kava.client.factory.Factory;
import org.cocktail.kava.client.finder.FinderTauxProrata;
import org.cocktail.kava.client.finder.FinderTypeEtat;
import org.cocktail.kava.client.metier.EOFacturePapier;
import org.cocktail.kava.client.metier.EOUtilisateur;
import org.cocktail.kava.client.procedures.ApiPrestation;
import org.cocktail.pieFwk.common.exception.EntityInitializationException;
import org.cocktail.pieFwk.common.exception.NoResultException;
import org.cocktail.pieFwk.common.exception.NonUniqueResultException;

public class FactoryFacturePapier
extends Factory {
    public FactoryFacturePapier() {
    }

    public FactoryFacturePapier(boolean withLog) {
        super(withLog);
    }

    public static EOFacturePapier newObject(EOEditingContext ec) throws EntityInitializationException {
        try {
            EOFacturePapier facturePapier = (EOFacturePapier)Factory.instanceForEntity(ec, "FacturePapier");
            facturePapier.setTypeEtatRelationship(FinderTypeEtat.typeEtatValide(ec));
            facturePapier.setFapDate(Factory.getDateJour());
            facturePapier.setTauxProrataRelationship(FinderTauxProrata.tauxProrata100(ec));
            ec.insertObject((EOEnterpriseObject)facturePapier);
            return facturePapier;
        }
        catch (NoResultException nre) {
            throw new EntityInitializationException(nre.getMessage());
        }
        catch (NonUniqueResultException nure) {
            throw new EntityInitializationException(nure.getMessage());
        }
    }

    public static void delFacturePapier(EOEditingContext ec, EOFacturePapier facturePapier, EOUtilisateur utilisateur) throws Exception {
        if (facturePapier == null || utilisateur == null) {
            throw new Exception("Il faut donner la facture papier ET un utilisateur pour supprimer une facture papier!!");
        }
        if (facturePapier.prestation() != null) {
            if (facturePapier.prestation().prestationLignes() != null) {
                ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(facturePapier.prestation().prestationLignes()));
            }
            ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)facturePapier.prestation())));
        }
        ApiPrestation.delFacturePapier(ec, facturePapier, utilisateur);
        if (facturePapier.facturePapierLignes() != null) {
            ec.invalidateObjectsWithGlobalIDs(ec._globalIDsForObjects(facturePapier.facturePapierLignes()));
        }
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)facturePapier)));
    }

    public static void updFapRef(EOEditingContext ec, EOFacturePapier facturePapier) throws Exception {
        if (facturePapier == null) {
            return;
        }
        ApiPrestation.updFapRef(ec, facturePapier);
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)facturePapier)));
    }

    public static void valideClient(EOEditingContext ec, EOFacturePapier facturePapier, EOUtilisateur utilisateur) throws Exception {
        if (facturePapier == null) {
            return;
        }
        if (facturePapier.fapDateValidationClient() != null) {
            return;
        }
        if (facturePapier.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La facture papier " + facturePapier.fapNumero() + " est annulee, impossible de la valider !");
        }
        if (!facturePapier.isValidableClient()) {
            throw new Exception("Il manque des informations cote client, impossible de valider la facture papier " + facturePapier.fapNumero() + " !");
        }
        ApiPrestation.valideFacturePapierClient(ec, facturePapier, utilisateur);
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)facturePapier)));
    }

    public static void devalideClient(EOEditingContext ec, EOFacturePapier facturePapier, EOUtilisateur utilisateur) throws Exception {
        if (facturePapier == null) {
            return;
        }
        if (facturePapier.fapDateValidationClient() == null) {
            return;
        }
        if (facturePapier.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La facture papier " + facturePapier.fapNumero() + " est annulee, impossible de la devalider !");
        }
        FactoryFacturePapier.devalidePrest(ec, facturePapier, utilisateur);
        ApiPrestation.devalideFacturePapierClient(ec, facturePapier, utilisateur);
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)facturePapier)));
    }

    public static void validePrest(EOEditingContext ec, EOFacturePapier facturePapier, EOUtilisateur utilisateur) throws Exception {
        if (facturePapier == null) {
            return;
        }
        if (facturePapier.fapDateValidationPrest() != null) {
            return;
        }
        if (facturePapier.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La facture papier " + facturePapier.fapNumero() + " est annulee, impossible de la valider !");
        }
        if (!facturePapier.isValidablePrest()) {
            throw new Exception("Il manque des informations cote prestataire, impossible de valider la facture papier " + facturePapier.fapNumero() + " !");
        }
        if (facturePapier.modeRecouvrement() != null && facturePapier.modeRecouvrement().isEcheancier() && facturePapier.echeId() == null) {
            throw new Exception("La facture papier " + facturePapier.fapNumero() + " est en mode de recouvrement Echeancier, et elle n'a pas d'echeancier rattache, a corriger pour pouvoir valider !");
        }
        FactoryFacturePapier.valideClient(ec, facturePapier, utilisateur);
        ApiPrestation.valideFacturePapierPrest(ec, facturePapier, utilisateur);
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)facturePapier)));
    }

    public static void devalidePrest(EOEditingContext ec, EOFacturePapier facturePapier, EOUtilisateur utilisateur) throws Exception {
        if (facturePapier == null) {
            return;
        }
        if (facturePapier.fapDateValidationPrest() == null) {
            return;
        }
        if (facturePapier.typeEtat().equals((Object)FinderTypeEtat.typeEtatAnnule(ec))) {
            throw new Exception("La facture papier " + facturePapier.fapNumero() + " est annulee, impossible de la devalider !");
        }
        ApiPrestation.devalideFacturePapierPrest(ec, facturePapier, utilisateur);
        ec.invalidateObjectsWithGlobalIDs(new NSArray((Object)ec.globalIDForObject((EOEnterpriseObject)facturePapier)));
    }
}

