/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.factory;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import org.cocktail.kava.client.factory.Factory;
import org.cocktail.kava.client.finder.FinderTauxProrata;
import org.cocktail.kava.client.finder.FinderTypeApplication;
import org.cocktail.kava.client.finder.FinderTypeEtat;
import org.cocktail.kava.client.metier.EOFacture;
import org.cocktail.kava.client.metier.EORecette;
import org.cocktail.pieFwk.common.exception.EntityInitializationException;
import org.cocktail.pieFwk.common.exception.NoResultException;
import org.cocktail.pieFwk.common.exception.NonUniqueResultException;

public class FactoryFacture
extends Factory {
    public FactoryFacture() {
    }

    public FactoryFacture(boolean withLog) {
        super(withLog);
    }

    public static EOFacture newObject(EOEditingContext ec) throws EntityInitializationException {
        try {
            EOFacture facture = (EOFacture)Factory.instanceForEntity(ec, "Facture");
            facture.setFacDateSaisie(Factory.getDateJour());
            facture.setTypeEtatRelationship(FinderTypeEtat.typeEtatValide(ec));
            facture.setTauxProrataRelationship(FinderTauxProrata.tauxProrata100(ec));
            ec.insertObject((EOEnterpriseObject)facture);
            return facture;
        }
        catch (NoResultException nre) {
            throw new EntityInitializationException(nre.getMessage());
        }
        catch (NonUniqueResultException nure) {
            throw new EntityInitializationException(nure.getMessage());
        }
    }

    public static EOFacture newObject(EOEditingContext ec, EORecette recette) throws EntityInitializationException {
        EOFacture facture = FactoryFacture.newObject(ec);
        facture.setExerciceRelationship(recette.exercice());
        facture.setTypeApplicationRelationship(FinderTypeApplication.typeApplicationRecette(ec));
        facture.setPersonneRelationship(recette.recettePapier().personne());
        facture.setFournisUlrRelationship(recette.recettePapier().fournisUlr());
        facture.setOrganRelationship(recette.facture().organ());
        facture.setTauxProrataRelationship(recette.facture().tauxProrata());
        facture.setTypeCreditRecRelationship(recette.facture().typeCreditRec());
        facture.setModeRecouvrementRelationship(recette.facture().modeRecouvrement());
        facture.setFacHtSaisie(recette.facture().facHtSaisie());
        facture.setFacTtcSaisie(recette.facture().facTtcSaisie());
        facture.setFacTvaSaisie(recette.facture().facTvaSaisie());
        facture.setFacLib(recette.facture().facLib());
        return facture;
    }
}

