/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.kava.client.factory;

import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eodistribution.client.EODistributedClassDescription;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSTimestamp;
import java.util.GregorianCalendar;

public class Factory {
    private boolean withLogs;

    public Factory() {
        this.setWithLogs(false);
    }

    public Factory(boolean withLog) {
        this.setWithLogs(withLog);
    }

    public static EOEnterpriseObject instanceForEntity(EOEditingContext ec, String entity) {
        try {
            EODistributedClassDescription description = (EODistributedClassDescription)EOClassDescription.classDescriptionForEntityName((String)entity);
            EOEnterpriseObject object = description.createInstanceWithEditingContext(ec, null);
            return object;
        }
        catch (Exception e) {
            System.err.println("Impossible de recuperer la description pour l'entite " + entity + ". Pas d'objet cree...");
            return null;
        }
    }

    public static NSArray fetchArray(EOEditingContext ec, String entityName, EOQualifier qualifier, NSArray sortOrderings) {
        try {
            EOFetchSpecification spec = new EOFetchSpecification(entityName, qualifier, sortOrderings);
            spec.setRefreshesRefetchedObjects(true);
            return ec.objectsWithFetchSpecification(spec);
        }
        catch (Exception e) {
            return new NSArray();
        }
    }

    public static EOEnterpriseObject fetchObject(EOEditingContext ec, String entityName, EOQualifier qualifier, NSArray sortOrderings) {
        NSArray res = Factory.fetchArray(ec, entityName, qualifier, sortOrderings);
        if (res == null || res.count() == 0) {
            return null;
        }
        return (EOEnterpriseObject)res.objectAtIndex(0);
    }

    public void trace(String prefix, NSArray a) {
        int i = 0;
        while (i < a.count()) {
            this.trace(String.valueOf(prefix) + "  " + i + "-->", a.objectAtIndex(i));
            ++i;
        }
    }

    public void trace(Object obj) {
        this.trace("", obj);
    }

    public void trace(String prefix, Object obj) {
        if (this.withLogs()) {
            if (obj == null) {
                System.out.println(String.valueOf(prefix) + " null");
            } else if (obj instanceof NSArray) {
                this.trace(prefix, (NSArray)obj);
            } else if (obj instanceof EOEnterpriseObject) {
                this.trace(prefix, (EOEnterpriseObject)obj);
            } else {
                System.out.println(String.valueOf(prefix) + obj.toString());
            }
        }
    }

    public void trace(String prefix, EOEnterpriseObject object) {
        if (object != null) {
            for (String obj : object.attributeKeys().vector()) {
                this.trace(String.valueOf(prefix) + "  " + obj + "-->", object.valueForKey(obj));
            }
            for (String obj : object.toOneRelationshipKeys().vector()) {
                this.trace(String.valueOf(prefix) + "  " + obj + "-->" + object.valueForKey(obj));
            }
            for (String obj : object.toManyRelationshipKeys().vector()) {
                if (prefix != null && prefix.length() > 250) {
                    this.trace(String.valueOf(prefix) + "  " + obj + "-->" + object.valueForKey(obj));
                    continue;
                }
                this.trace(String.valueOf(prefix) + "  " + obj + "-->", object.valueForKey(obj));
            }
        }
    }

    public void setWithLogs(boolean b) {
        this.withLogs = b;
    }

    public boolean withLogs() {
        return this.withLogs;
    }

    private static final GregorianCalendar getToday() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc;
    }

    public static final NSTimestamp getDateJour() {
        return new NSTimestamp(Factory.getToday().getTime());
    }
}

